/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanediting.listeners;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.activator.Activator;
import de.fzi.kamp.ui.workplanediting.listeners.AddCompositeActivityListener;
import de.fzi.kamp.ui.workplanediting.listeners.DeleteActivityFromWorkplanListener;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;

public class ContextMenuMouseListenerForWorkplanTree
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(ContextMenuMouseListenerForWorkplanTree.class);
    private Tree tree;
    private IMainEditor mainEditor;
    private static final int RIGHT_MOUSE_BUTTON = 3;

    public ContextMenuMouseListenerForWorkplanTree(Tree tree, IMainEditor mainEditor) {
        this.tree = tree;
        this.mainEditor = mainEditor;
    }

    public void mouseDown(MouseEvent e) {
        if (!this.mainEditor.getCentralPage().effortEstimationViewIsActivated() && e.button == 3 && e.widget instanceof Tree) {
            Activity task = (Activity)this.tree.getSelection()[0].getData();
            boolean isRootComposite = false;
            if (task instanceof CompositeTask && ((CompositeTask)task).getTaskrationale().getKeyword().equals("Complete Workplan")) {
                isRootComposite = true;
            }
            if (!isRootComposite) {
                Menu rightButton = new Menu((Control)this.tree);
                MenuItem addItem = this.createMenuItem(rightButton, 64, "Edit");
                addItem.addSelectionListener((SelectionListener)new AddCompositeActivityListener(this.tree, this.mainEditor));
                if (task instanceof ImplementOperationActivity || task instanceof ChangeOperationImplementationActivity || task instanceof RemoveOperationImplementationActivity) {
                    addItem.setEnabled(false);
                }
                this.createMenuItem(rightButton, 2, "");
                MenuItem deleteItem = this.createMenuItem(rightButton, 64, "Delete Activity");
                deleteItem.addSelectionListener((SelectionListener)new DeleteActivityFromWorkplanListener(this.mainEditor, this.tree.getSelection()[0]));
                if (this.tree.getSelection()[0].getItemCount() > 0) {
                    deleteItem.setEnabled(false);
                }
                this.tree.setMenu(rightButton);
            } else if (this.tree.getMenu() != null) {
                this.tree.getMenu().dispose();
            }
        }
        super.mouseDown(e);
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(text);
        ImageDescriptor desc = Activator.getImageDescriptor("/icons/qimpress.gif");
        item.setImage(desc.createImage());
        return item;
    }
}

