/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.DataTypeSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.DataTypeCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.DataTypesComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectDatatypesPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SelectDatatypesPage.class);
    private SurfaceFactory factory = new SurfaceFactory();
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private Map<DataTypeSelectionContainer, DataTypeSelectionContainerDecorator> container2decoratorMap;

    protected SelectDatatypesPage(CompositeTaskDerivationContainer workplanContainer) {
        super("datatypePage");
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.container2decoratorMap = new HashMap<DataTypeSelectionContainer, DataTypeSelectionContainerDecorator>();
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setTitle("Select the activities you are going\n to perform for Datatypes");
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 16384, 1, 0, true, 10, 10);
        this.setControl((Control)container);
        this.setDescription("Please check the datatypes affected by your change request.");
        Table table = this.factory.createTable(container, 1, new String[]{"!", "Datatype", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getDataTypeSelectionContainers()) {
            TableItem item = new TableItem(table, 0);
            item.setText(1, datatypeContainer.getType().getName());
            item.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
            table.getColumn(1).pack();
            Button checkbox = new Button((Composite)table, 32);
            this.factory.setControlWithTableEditor(table, item, (Control)checkbox, 0);
            checkbox.setToolTipText("Check this, if the datatype is affected within the current composite activity.");
            table.getColumn(0).pack();
            table.update();
            Combo combo = new Combo((Composite)table, 8);
            combo.add(BasicActivity.CHANGE.toString());
            combo.setEnabled(false);
            this.factory.setControlWithTableEditor(table, item, (Control)combo, 2);
            combo.setToolTipText("Please specify the basic activity for this datatype.");
            table.getColumn(2).pack();
            table.redraw();
            DataTypeSelectionContainerDecorator decorator = new DataTypeSelectionContainerDecorator(datatypeContainer);
            this.container2decoratorMap.put(datatypeContainer, decorator);
            item.setData((Object)datatypeContainer);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);
            this.workplanContainer.getLastShownDataTypeSelectionContainers().add((Object)datatypeContainer);
            checkbox.addSelectionListener((SelectionListener)new DataTypeCheckboxListener(this, decorator));
            combo.addSelectionListener((SelectionListener)new DataTypesComboListener(this, decorator));
            this.setPageComplete(true);
            if (!datatypeContainer.isSelected()) continue;
            checkbox.setSelection(true);
            checkbox.setEnabled(false);
            combo.setText(combo.getItem(0));
        }
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        List selectedDatatypes = this.workplanDerivationManager.getSelectedDatatypes();
        if (selectedDatatypes.isEmpty()) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (DataTypeSelectionContainer datatypeContainer : selectedDatatypes) {
            DataTypeSelectionContainerDecorator selection = this.container2decoratorMap.get(datatypeContainer);
            if (datatypeContainer.getBasicActivity() == null) {
                selection.getTableItem().setBackground(2, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                this.setErrorMessage("If you check a component, you have to choose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            selection.getTableItem().setBackground(2, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
        }
        return checkedAndSelected;
    }
}

