/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.commands.DeriveWorkplanCommand;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.CompositeTaskDerivationContainerBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.InitialForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.NamingChangingRationalPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectOperationPage;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class DeriveWorkPlanWizard
extends AbstractWizard
implements IWizard {
    private static final Logger logger = Logger.getLogger(DeriveWorkPlanWizard.class);
    private CompositeTaskDerivationContainer milestoneContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private IMainEditor mainEditor;
    private EffortAnalysisInstance analysisInstance;
    private InitialForkPage forkPage;
    private NamingChangingRationalPage rationalPage;
    private SelectComponentActivitiesWizardPage compPage;
    private SelectInterfacePortPage interfacePortPage;
    private SelectOperationPage operationPage;
    private SelectInterfacesPage interfacePage;
    private SelectDatatypesPage datatypePage;
    private IWizardPage activePage;

    public DeriveWorkPlanWizard(EffortAnalysisInstance instance, IMainEditor editor, IArchitectureModelProvider architectureModelProvider) {
        this.analysisInstance = instance;
        this.createMilestoneContainer(architectureModelProvider);
        this.workplanDerivationManager = new WorkplanDerivationManager(this.milestoneContainer);
        this.mainEditor = editor;
        this.rationalPage = new NamingChangingRationalPage(((CompositeTask)this.milestoneContainer.getActivity()).getTaskrationale());
        this.forkPage = new InitialForkPage();
        this.compPage = new SelectComponentActivitiesWizardPage(this.milestoneContainer);
        this.interfacePortPage = new SelectInterfacePortPage(this.milestoneContainer);
        this.operationPage = new SelectOperationPage(this.milestoneContainer);
        this.interfacePage = new SelectInterfacesPage(this.milestoneContainer);
        this.datatypePage = new SelectDatatypesPage(this.milestoneContainer);
        this.activePage = this.compPage;
    }

    private void cleanup() {
        this.rationalPage.dispose();
        this.forkPage.dispose();
        this.compPage.dispose();
        this.interfacePortPage.dispose();
        this.interfacePage.dispose();
        this.datatypePage.dispose();
    }

    @Override
    public boolean performFinish() {
        this.cleanup();
        DeriveWorkplanCommand command = new DeriveWorkplanCommand(this.analysisInstance.getWorkplan(), this.mainEditor, this.milestoneContainer, this.workplanDerivationManager);
        this.mainEditor.handleCommand((Command)command);
        if (this.getItemAdapter() != null) {
            this.getItemAdapter().notifyChanged(null);
        }
        return true;
    }

    @Override
    public boolean canFinish() {
        if (this.activePage == this.compPage) {
            return true;
        }
        if (this.activePage == this.interfacePortPage) {
            return true;
        }
        if (this.activePage == this.operationPage) {
            return true;
        }
        return super.canFinish();
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)this.rationalPage);
        this.addPage((IWizardPage)this.forkPage);
        this.addPage((IWizardPage)this.compPage);
        this.addPage((IWizardPage)this.interfacePortPage);
        this.addPage((IWizardPage)this.operationPage);
        this.addPage((IWizardPage)this.interfacePage);
        this.addPage((IWizardPage)this.datatypePage);
        this.setWindowTitle("Select Work Activities");
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.rationalPage) {
            return this.forkPage;
        }
        if (page == this.compPage) {
            this.getPageList().remove((Object)this.interfacePortPage);
            this.interfacePortPage = new SelectInterfacePortPage(this.milestoneContainer);
            this.addPage((IWizardPage)this.interfacePortPage);
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page == this.interfacePortPage) {
            this.getPageList().remove((Object)this.operationPage);
            this.operationPage = new SelectOperationPage(this.milestoneContainer);
            this.addPage((IWizardPage)this.operationPage);
            this.activePage = this.operationPage;
            return this.operationPage;
        }
        if (page == this.interfacePage) {
            this.getPageList().remove((Object)this.interfacePortPage);
            this.interfacePortPage = new SelectInterfacePortPage(this.milestoneContainer);
            this.addPage((IWizardPage)this.interfacePortPage);
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page == this.datatypePage) {
            this.getPageList().remove((Object)this.interfacePage);
            this.interfacePage = new SelectInterfacesPage(this.milestoneContainer);
            this.addPage((IWizardPage)this.interfacePage);
            this.activePage = this.interfacePage;
            return this.interfacePage;
        }
        return super.getNextPage(page);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.compPage) {
            this.activePage = page;
            return null;
        }
        if (page == this.interfacePortPage) {
            this.activePage = this.compPage;
            return this.compPage;
        }
        if (page == this.operationPage) {
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page instanceof SelectInterfacesPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    public List<ComponentSelectionContainer> getSelectedComponents() {
        return this.workplanDerivationManager.getSelectedComponents();
    }

    public int getSelectionIndex(AbstractContainer operationContainer) {
        switch (operationContainer.getBasicActivity()) {
            case ADD: {
                return 0;
            }
            case CHANGE: {
                return 1;
            }
            case REMOVE: {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public boolean performCancel() {
        this.cleanup();
        this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().remove((Object)this.milestoneContainer);
        return super.performCancel();
    }

    private AnalysisInstanceItemAdapter getItemAdapter() {
        for (Adapter adapter : this.analysisInstance.eAdapters()) {
            if (!(adapter instanceof AnalysisInstanceItemAdapter)) continue;
            return (AnalysisInstanceItemAdapter)adapter;
        }
        return null;
    }

    private void createMilestoneContainer(IArchitectureModelProvider architectureModelProvider) {
        this.milestoneContainer = SelectioncontainerFactoryImpl.eINSTANCE.createCompositeTaskDerivationContainer();
        new CompositeTaskDerivationContainerBuilder(architectureModelProvider).fillWorkplanDerivationContainer(this.milestoneContainer, this.analysisInstance);
        CompositeTask milestoneActivity = WorkplanFactory.eINSTANCE.createCompositeTask();
        milestoneActivity.setTaskrationale(this.createEmptyTaskRationale());
        this.milestoneContainer.setActivity((Activity)milestoneActivity);
        this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().add((Object)this.milestoneContainer);
        ((CompositeTaskDerivationContainer)this.analysisInstance.getWorkplan().getCompositetaskderivationcontainer().get(0)).getTopLevelActivityContainer().add((Object)this.milestoneContainer);
        this.analysisInstance.getWorkplan().getTasks().add((Object)milestoneActivity);
    }

    private TaskRationale createEmptyTaskRationale() {
        TaskRationale rationale = WorkplanFactory.eINSTANCE.createTaskRationale();
        rationale.setDescription("");
        rationale.setKeyword("");
        return rationale;
    }
}

