/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener.FurtherDerivationCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.listener.FurtherDerivationComboListener;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.CompositeTaskContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.FurtherDerivationTreeContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.providers.FurtherDerivationtTreeLabelProvider;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SelectElementTypesPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SelectElementTypesPage.class);
    public static final int CHECKBOX_COLUMN_NO = 0;
    public static final int ELEMENT_TYPE_COLUMN_NO = 1;
    public static final int NAME_COLUMN_NO = 2;
    public static final int COMBO_COLUMN_NO = 3;
    public static final String[] HEADINGS_ARRAY = new String[]{"?", "Element Type", "Name", "Basic Activity"};
    private Tree changeSelectionTree;
    private TreeViewer treeViewer;
    private boolean itemIsIncomplete = false;
    private Map<TreeItem, Button> treeItemToCheckboxMap = new HashMap<TreeItem, Button>();
    private Map<Button, Combo> checkboxTocomboMap = new HashMap<Button, Combo>();
    private SurfaceFactory factory = new SurfaceFactory();

    public SelectElementTypesPage() {
        super("beginningPage");
    }

    public void createControl(Composite parent) {
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 16384, 1, 0, true, 10, 10);
        this.getShell().setMinimumSize(600, 500);
        this.setTitle("If elements are grayed, it is not possible to uncheck them or change basic activity.");
        this.changeSelectionTree = this.factory.createTree(container, 4, 1, true, 67584, HEADINGS_ARRAY);
        this.factory.setGrabVerticalForGridData((Control)this.changeSelectionTree, true, 4, false);
        this.changeSelectionTree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 22;
            }
        });
        this.treeViewer = new TreeViewer(this.changeSelectionTree);
        if (((FurtherDerivationWizard)this.getWizard()).getInput() != null) {
            this.setTreeViewerToTree(((FurtherDerivationWizard)this.getWizard()).getInput());
        }
        this.setControl((Control)container);
    }

    public void setTreeViewerToTree(List<AbstractContainer> input) {
        if (input.size() > 0 && input.get(0) instanceof CompositeTaskDerivationContainer) {
            this.treeViewer.setContentProvider((IContentProvider)new CompositeTaskContentProvider());
        } else {
            this.treeViewer.setContentProvider((IContentProvider)new FurtherDerivationTreeContentProvider());
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FurtherDerivationtTreeLabelProvider());
        this.treeViewer.setInput(input);
        this.treeViewer.expandAll();
        this.checkAlreadyChosenContainers(this.changeSelectionTree.getItems());
        this.addCheckboxAndComboToTreeItems((Widget)this.changeSelectionTree, this.changeSelectionTree.getItems());
        this.changeSelectionTree.getColumn(0).setWidth(100);
        this.changeSelectionTree.getColumn(1).pack();
        this.changeSelectionTree.getColumn(2).pack();
    }

    private void checkAlreadyChosenContainers(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractContainer container;
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                this.checkAlreadyChosenContainers(item.getItems());
            }
            if ((container = (AbstractContainer)item.getData()).isSelected()) {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    public Tree getCurrentTree() {
        return this.changeSelectionTree;
    }

    public void addCheckboxAndComboToTreeItems(Widget directParentItem, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                this.addCheckboxAndComboToTreeItems((Widget)item, item.getItems());
            }
            AbstractContainer container = (AbstractContainer)item.getData();
            Combo combo = new Combo((Composite)this.changeSelectionTree, 8);
            combo.addSelectionListener((SelectionListener)new FurtherDerivationComboListener(item, combo, this));
            this.factory.setControlWithTableTreeEditor(this.changeSelectionTree, item, (Control)combo, 3);
            Button checkbox = new Button((Composite)this.changeSelectionTree, 32);
            checkbox.addSelectionListener((SelectionListener)new FurtherDerivationCheckboxListener(checkbox, combo, this, item));
            this.factory.setControlWithTableTreeEditor(this.changeSelectionTree, item, (Control)checkbox, 0);
            this.treeItemToCheckboxMap.put(item, checkbox);
            this.checkboxTocomboMap.put(checkbox, combo);
            if (container instanceof InterfaceSelectionContainer || container instanceof DataTypeSelectionContainer) {
                combo.add(BasicActivity.CHANGE.toString());
            } else {
                combo.add("ADD");
                combo.add("CHANGE");
                combo.add("REMOVE");
            }
            if (container.isSelected()) {
                checkbox.setSelection(true);
            } else {
                combo.setEnabled(false);
            }
            if (this.checkIfRefinementIsSelected(item)) {
                this.checkCheckbox(item, false);
            }
            this.adaptMenuInCombo(item);
            if (container.isSelected()) {
                this.setSelectedBasicActivity(container.getBasicActivity(), combo);
            }
            ++n2;
        }
    }

    private void setSelectedBasicActivity(BasicActivity basicActivity, Combo combo) {
        switch (basicActivity) {
            case ADD: {
                combo.setText(BasicActivity.ADD.toString());
                break;
            }
            case CHANGE: {
                combo.setText(BasicActivity.CHANGE.toString());
                break;
            }
            case REMOVE: {
                combo.setText(BasicActivity.REMOVE.toString());
                break;
            }
            default: {
                combo.setText("");
            }
        }
    }

    public Map<TreeItem, Button> getTreeItemTocheckboxMap() {
        return this.treeItemToCheckboxMap;
    }

    public boolean checkIfRefinementIsSelected(TreeItem item) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (this.treeItemToCheckboxMap.get(child).getSelection()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void checkCheckbox(TreeItem item, boolean doCheck) {
        Button checkbox = this.treeItemToCheckboxMap.get(item);
        checkbox.setEnabled(doCheck);
        this.checkboxTocomboMap.get(checkbox).setEnabled(doCheck);
    }

    public void adaptMenuInCombo(TreeItem parentItem) {
        Assert.isNotNull((Object)parentItem.getData(), (String)"Selection container is missing at tree item for further derivation wizard");
        switch (((AbstractContainer)parentItem.getData()).getBasicActivity()) {
            case ADD: {
                this.setMenuToCombo(parentItem, new BasicActivity[]{BasicActivity.ADD});
                break;
            }
            case CHANGE: {
                this.setMenuToCombo(parentItem, new BasicActivity[]{BasicActivity.ADD, BasicActivity.CHANGE, BasicActivity.REMOVE});
                break;
            }
            case REMOVE: {
                this.setMenuToCombo(parentItem, new BasicActivity[]{BasicActivity.REMOVE});
            }
        }
    }

    public void updateFinishButton(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (child.getItems().length > 0 && !this.itemIsIncomplete) {
                this.updateFinishButton(child.getItems());
            }
            Button currentCheckbox = this.treeItemToCheckboxMap.get(child);
            Combo combo = this.checkboxTocomboMap.get(currentCheckbox);
            if (currentCheckbox.getSelection() && combo.getSelectionIndex() == -1) {
                ((FurtherDerivationWizard)this.getWizard()).setCanFinish(false);
                this.setPageComplete(false);
                this.itemIsIncomplete = true;
                break;
            }
            if (!this.itemIsIncomplete) {
                ((FurtherDerivationWizard)this.getWizard()).setCanFinish(true);
                this.setPageComplete(true);
            }
            ++n2;
        }
    }

    private void setMenuToCombo(TreeItem parentItem, BasicActivity[] menuText) {
        TreeItem[] treeItemArray = parentItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            Combo currentCombo = this.checkboxTocomboMap.get(this.treeItemToCheckboxMap.get(child));
            currentCombo.removeAll();
            currentCombo.clearSelection();
            BasicActivity[] basicActivityArray = menuText;
            int n3 = menuText.length;
            int n4 = 0;
            while (n4 < n3) {
                BasicActivity basicActivity = basicActivityArray[n4];
                currentCombo.add(basicActivity.toString());
                ++n4;
            }
            if (((AbstractContainer)child.getData()).isSelected()) {
                this.setSelectedBasicActivity(((AbstractContainer)child.getData()).getBasicActivity(), currentCombo);
            }
            ++n2;
        }
    }

    public void resetItemIsIncompleteBoolean() {
        this.itemIsIncomplete = false;
    }

    public Tree getChangeSelectionTree() {
        return this.changeSelectionTree;
    }
}

