/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.pages;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.ShowComponentConnectorsButtonListener;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.CalculateFollowUpWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.Names;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.StartingPageTableContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.provider.StartingPageTableLabelProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches.FollowUpAdaptationActivitiesSwitch;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;

public class StartingPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(StartingPage.class);
    private Tree workplanTree;
    private List<TableEditor> tableEditors;
    private SurfaceFactory factory = new SurfaceFactory();
    private static final int BUTTON_COLUMN_INDEX = 2;

    public StartingPage(Tree workplanTree) {
        super(Names.getStartingpageName());
        this.workplanTree = workplanTree;
        this.tableEditors = new LinkedList<TableEditor>();
    }

    public void createControl(Composite parent) {
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 16384, 1, 0, true, 10, 10);
        this.setTitle("Follow up calculator");
        this.setDescription("Here all marked architecture elements are shown, which are affected by an signature change. Please choose \n the architecture elements of which you know, that theycause changes in connected components.");
        Table table = this.factory.createTable(container, 1, Names.getHeadingsForStartingPageTable(), 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        this.fillTable(table);
        this.setControl((Control)container);
    }

    private void fillTable(Table table) {
        table.removeAll();
        this.removeAllTableEdtors();
        CompositeTask compositeTask = (CompositeTask)this.workplanTree.getSelection()[0].getData();
        LinkedList<Activity> resultingComponents = new LinkedList<Activity>();
        FollowUpAdaptationActivitiesSwitch acivitiesSwitch = new FollowUpAdaptationActivitiesSwitch(resultingComponents);
        for (Activity activity : compositeTask.getSubtasks()) {
            acivitiesSwitch.doSwitch((EObject)activity);
        }
        this.setContentAndLabelProvider(resultingComponents, table);
        this.setStartConnectorFollowingButtons(table);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private void setContentAndLabelProvider(List<Activity> resultingComponents, Table table) {
        TableViewer tableViewer = new TableViewer(table);
        StartingPageTableContentProvider contentProvider = new StartingPageTableContentProvider();
        StartingPageTableLabelProvider labelProvider = new StartingPageTableLabelProvider();
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        tableViewer.setInput(resultingComponents);
    }

    private void setStartConnectorFollowingButtons(Table table) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Button button = new Button((Composite)table, 0);
            button.setText("Go!");
            button.addSelectionListener((SelectionListener)new ShowComponentConnectorsButtonListener((CalculateFollowUpWizard)this.getWizard(), (ComponentActivity)tableItem.getData()));
            TableEditor tableEditor = new TableEditor(table);
            this.tableEditors.add(tableEditor);
            tableEditor.grabHorizontal = true;
            tableEditor.grabVertical = true;
            tableEditor.setEditor((Control)button, tableItem, 2);
            ++n2;
        }
    }

    private void removeAllTableEdtors() {
        for (TableEditor tableEditor : this.tableEditors) {
            tableEditor.dispose();
        }
    }
}

