/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workorganisation.listeners;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.ui.activator.Activator;
import de.fzi.kamp.ui.workorganisation.listeners.DeleteWOElementSelectionistener;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ContextMenuForDeletingAssignedWOElementListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(ContextMenuForDeletingAssignedWOElementListener.class);
    private ICommandHandler commandHandler;
    private TableViewer assignedDevelopersViewer;
    private Table mappingTable;
    private static final int RIGHT_MOUSE_BUTTON = 3;

    public ContextMenuForDeletingAssignedWOElementListener(ICommandHandler editor, TableViewer assignedDevelopersViewer, Table mappingTable) {
        this.commandHandler = editor;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
        this.mappingTable = mappingTable;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 3 && e.widget instanceof Table) {
            Table table = (Table)e.widget;
            Menu rightButton = new Menu((Control)table);
            if (this.getSelectedComponent() != null) {
                AbstractModelElement modelElement = this.getSelectedComponent();
                MenuItem deleteItem = this.createMenuItem(rightButton, 64, "Delete selected workorganisation element");
                if (table.getSelection()[0] != null && table.getSelection()[0].getData() instanceof WorkOrganisationElement) {
                    TableItem selectedItem = table.getSelection()[0];
                    WorkOrganisationElement workorganisationElement = (WorkOrganisationElement)selectedItem.getData();
                    deleteItem.addSelectionListener((SelectionListener)new DeleteWOElementSelectionistener(workorganisationElement, this.commandHandler, this.assignedDevelopersViewer, modelElement));
                }
                table.setMenu(rightButton);
            }
        }
        super.mouseDown(e);
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(text);
        ImageDescriptor desc = Activator.getImageDescriptor("/icons/qimpress.gif");
        item.setImage(desc.createImage());
        return item;
    }

    private AbstractModelElement getSelectedComponent() {
        if (this.mappingTable.getSelection()[0].getData() instanceof AbstractModelElement) {
            return (AbstractModelElement)this.mappingTable.getSelection()[0].getData();
        }
        return null;
    }
}

