/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.preparation.adapter.ChangeRequestContentAdapter;
import de.fzi.kamp.ui.preparation.listeners.AddChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.EditChangeRequestListener;
import de.fzi.kamp.ui.preparation.listeners.RemoveChangeRequestListener;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SpecifyChangeScenarioLayer {
    private static final Logger logger = Logger.getLogger(SpecifyChangeScenarioLayer.class);
    private static final String CHANGE_REQUEST_SECTION_HEADING = "Change Request Description:";
    private static final String TABLE_HEADING_NAME = "Name";
    private static final String TABLE_HEADING_DESCRIPTION = "Description";
    private static final String TABLE_HEADING_AUTOMATED = "Automated?";
    private Display display;
    private MainEditorUI mainEditorUI;
    private SurfaceFactory factory = new SurfaceFactory();

    public void createChangeScenarioLayer(AnalysisManager analysisManager, IMainEditor mainEditor, ScrolledForm form) {
        this.setupChangeScenarioLayer(mainEditor);
        this.createChangeRequestPart(analysisManager, this.display, form);
    }

    public void setupChangeScenarioLayer(IMainEditor mainEditor) {
        this.mainEditorUI = (MainEditorUI)mainEditor;
        this.display = this.mainEditorUI.getEditorSite().getShell().getDisplay();
    }

    private void createChangeRequestPart(AnalysisManager analysisManager, Display display, ScrolledForm form) {
        Section changeRequestSection = this.factory.createSection(form.getBody(), CHANGE_REQUEST_SECTION_HEADING, 256, 128, true, display, 1);
        Composite sectionClient2 = this.factory.createCompositeForSection((Composite)changeRequestSection, 2, 4, 1, 0, 15, 15, display);
        Table changeReqTable = this.factory.createTable(sectionClient2, 1, new String[]{TABLE_HEADING_NAME, TABLE_HEADING_DESCRIPTION, TABLE_HEADING_AUTOMATED}, 4, true);
        this.factory.setSizeForControl((Composite)changeReqTable, 0, 150, false);
        SelectionAdapter[] listenersChangeButtons = new SelectionAdapter[]{new AddChangeRequestListener(changeReqTable, analysisManager), new EditChangeRequestListener(changeReqTable, analysisManager), new RemoveChangeRequestListener(changeReqTable, analysisManager)};
        this.factory.createVerticalButtonComposite(sectionClient2, 131072, 4, null, 0, listenersChangeButtons, null, new Image[]{ActivityImageProvider.getIconForAddButton(), ActivityImageProvider.getIconForEditButton(), ActivityImageProvider.getIconForDeleteButton()});
        analysisManager.getAnalysisModel().eAdapters().add((Object)new ChangeRequestContentAdapter(changeReqTable, analysisManager.getAnalysisModel()));
        changeRequestSection.setClient((Control)sectionClient2);
    }

    protected void finalize() throws Throwable {
        this.factory.cleanup();
        super.finalize();
    }
}

