/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.MainEditorUI;
import de.fzi.kamp.ui.preparation.adapter.ArchitectureAlternativesContentAdapter;
import de.fzi.kamp.ui.preparation.listeners.EditAlternativeListener;
import de.fzi.kamp.ui.preparation.listeners.LoadArchiAltListener;
import de.fzi.kamp.ui.preparation.listeners.RemoveArchitectureListener;
import de.fzi.kamp.ui.workorganisation.listeners.MapElementsToTeamsButtonlistener;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SpecifyArchitectureAlternativesLayer {
    private static final Logger logger = Logger.getLogger(SpecifyArchitectureAlternativesLayer.class);
    private static final String ARCHITECTURE_ALTERNATIVE_SECTION_HEADING = "Architecture Alternatives:";
    private static final String TABLE_HEADING_NAME = "Name";
    private static final String TABLE_HEADING_DESCRIPTION = "Description";
    private static final String[] ARCHI_ALT_BUTTONLABELS = new String[]{"", "", "", "Check Workorganisation Annotation"};
    private Display display;
    private MainEditorUI mainEditorUI;
    private SurfaceFactory factory = new SurfaceFactory();

    public void createArchitectureAlternativeLayer(AnalysisManager analysisManager, IMainEditor mainEditor, ScrolledForm form) {
        this.setupArchitectureAlternativeLayer(mainEditor);
        this.createArchitectureAlternativePart(analysisManager, this.display, form);
    }

    public void setupArchitectureAlternativeLayer(IMainEditor mainEditor) {
        this.mainEditorUI = (MainEditorUI)mainEditor;
        this.display = this.mainEditorUI.getEditorSite().getShell().getDisplay();
    }

    private void createArchitectureAlternativePart(AnalysisManager analysisManager, Display display, ScrolledForm form) {
        Section architectureAltSection = this.factory.createSection(form.getBody(), ARCHITECTURE_ALTERNATIVE_SECTION_HEADING, 256, 128, true, display, 1);
        Composite sectionClient1 = this.factory.createCompositeForSection((Composite)architectureAltSection, 2, 4, 1, 0, 15, 15, display);
        Table archiAltTable = this.factory.createTable(sectionClient1, 1, new String[]{TABLE_HEADING_NAME, TABLE_HEADING_DESCRIPTION}, 4, true);
        this.factory.setSizeForControl((Composite)archiAltTable, 0, 150, false);
        SelectionAdapter[] listenersAtlernativeButtons = new SelectionAdapter[]{new LoadArchiAltListener(analysisManager), new EditAlternativeListener(archiAltTable, analysisManager), new RemoveArchitectureListener(analysisManager, archiAltTable), new MapElementsToTeamsButtonlistener(archiAltTable, analysisManager.getPreparationManager(), display, this.mainEditorUI)};
        analysisManager.getAnalysisModel().eAdapters().add((Object)new ArchitectureAlternativesContentAdapter(archiAltTable, analysisManager.getAnalysisModel()));
        this.factory.createVerticalButtonComposite(sectionClient1, 131072, 4, ARCHI_ALT_BUTTONLABELS, 0, listenersAtlernativeButtons, null, new Image[]{ActivityImageProvider.getIconForAddButton(), ActivityImageProvider.getIconForEditButton(), ActivityImageProvider.getIconForDeleteButton()});
        this.fillInSAMModels(archiAltTable, analysisManager);
        architectureAltSection.setClient((Control)sectionClient1);
    }

    private void fillInSAMModels(Table archiAltTable, AnalysisManager analysisManager) {
        for (AbstractArchitectureModel architectureModel : analysisManager.getAnalysisModel().getArchitecturemodels()) {
            if (this.architectureModelAlreadyContained(archiAltTable, architectureModel)) continue;
            ArchitecturalAlternative alternative = WorkplanFactory.eINSTANCE.createArchitecturalAlternative();
            alternative.setArchitecturemodel(architectureModel);
            alternative.setName(architectureModel.getName());
            alternative.setDescription("Alternative from Workspace");
            analysisManager.getAnalysisModel().getArchitecturealternatives().add((Object)alternative);
        }
    }

    private boolean architectureModelAlreadyContained(Table archiAltTable, AbstractArchitectureModel architectureModel) {
        TableItem[] tableItemArray = archiAltTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (((ArchitecturalAlternative)tableItem.getData()).getArchitecturemodel() == architectureModel) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.factory.cleanup();
        super.finalize();
    }
}

