/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor;

import de.fzi.kamp.service.architecturemodel.ArchitectureModelProviderFactory;
import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.general.IDialogManager;
import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.ICentralEditorPage;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.general.DialogManager;
import de.fzi.kamp.ui.general.WizardManager;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;
import de.fzi.maintainabilitymodel.main.presentation.MainActionBarContributor;
import de.fzi.maintainabilitymodel.main.presentation.MainEditor;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import de.fzi.maintainabilitymodel.workorganisation.WorkorganisationFactory;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class MainEditorUI
extends MainEditor
implements IMenuListener,
IEditingDomainProvider,
IMainEditor,
ICommandHandler {
    private static final Logger logger = Logger.getLogger(MainEditorUI.class);
    private AnalysisManager analysisManager;
    private IArchitectureModelProvider architectureModelProvider;
    private CentralEditorPage centralPageFactory;
    private Control centralPage;
    private int centralPageIndex;
    private IProject parentQImpressProject;

    public AnalysisManager getAnalysisManager() {
        return this.analysisManager;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ComposedAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public MainEditorUI() {
        BasicConfigurator.configure();
    }

    public void createPages() {
        this.createModel();
        this.addCentralPage();
        this.createContextMenuFor((StructuredViewer)this.centralPageFactory.getWorkorganisationTreeViewer());
    }

    private void addCentralPage() {
        this.centralPageFactory = new CentralEditorPage();
        this.centralPage = this.centralPageFactory.createAnalysisAndWorkplanForm(this.analysisManager, this.getEditorSite().getShell().getDisplay(), this.getContainer(), this);
        this.setCurrentViewer((Viewer)this.centralPageFactory.getWorkorganisationTreeViewer());
        this.centralPageIndex = this.addPage(this.centralPage);
        this.setPageText(this.centralPageIndex, "Analysis");
    }

    public boolean isDirty() {
        return this.editingDomain.getCommandStack() != null ? ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() : false;
    }

    public void doSave(IProgressMonitor monitor) {
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createModel() {
        Resource res;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Resource resource = null;
        resource = this.editingDomain.getResourceSet().createResource(resourceURI);
        Path path = new Path(resourceURI.toString());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)path);
        this.parentQImpressProject = workspaceRoot.getProject(file.getParent().getName());
        Map loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        try {
            resource.load(loadOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.editingDomain.getResourceSet().getResources().isEmpty() && (res = (Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().size() > 0 && res.getContents().get(0) instanceof MaintainabilityAnalysisModel) {
            MaintainabilityAnalysisModel analysisModel = (MaintainabilityAnalysisModel)res.getContents().get(0);
            this.architectureModelProvider = ArchitectureModelProviderFactory.createArchitectureModelProvider((ResourceSet)this.editingDomain.getResourceSet(), (MaintainabilityAnalysisModel)analysisModel, (IMainEditor)this);
            if (analysisModel.getWorkorganisation().isEmpty()) {
                WorkOrganisationModel workOrganisationModel = WorkorganisationFactory.eINSTANCE.createWorkOrganisationModel();
                analysisModel.getWorkorganisation().add((Object)workOrganisationModel);
            }
            this.analysisManager = new AnalysisManager(analysisModel, this.architectureModelProvider, (IDialogManager)new DialogManager(this), (IWizardManager)new WizardManager(), (IMainEditor)this);
        }
    }

    public void showWorkplanChanges(Workplan workplan, boolean isEditableEffort) {
        this.centralPageFactory.setWorkplanAsTopControl();
        this.centralPageFactory.setViewForOpenedWorkplan(workplan, false, isEditableEffort, false);
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        super.createContextMenuFor(viewer);
        if (this.getActionBarContributor() instanceof MainActionBarContributor) {
            this.getActionBarContributor().setActiveEditor((IEditorPart)this);
            viewer.addSelectionChangedListener((ISelectionChangedListener)((MainActionBarContributor)this.getActionBarContributor()));
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MainEditorUI.this.centralPageFactory.getWorkorganisationTreeViewer() != null) {
                        MainEditorUI.this.centralPageFactory.getWorkorganisationTreeViewer().setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public ICentralEditorPage getCentralPage() {
        return this.centralPageFactory;
    }

    public IArchitectureModelProvider getArchitectureModelProvider() {
        return this.architectureModelProvider;
    }

    public void handleCommand(Command command) {
        logger.debug((Object)command.toString());
        this.getCommandStack().execute(command);
    }

    public Shell getMainEditorShell() {
        return this.getEditorSite().getShell();
    }

    public IProject getParentprojectOfKampFile() {
        return this.parentQImpressProject;
    }

    public void notifyAnalysisInstanceAdapter(EffortAnalysisInstance instance) {
        for (Adapter adapter : instance.eAdapters()) {
            if (!(adapter instanceof AnalysisInstanceItemAdapter)) continue;
            ((AnalysisInstanceItemAdapter)adapter).manualUpdateAfterautomaticDerivation();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

