/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.analysisoverview.listeners;

import de.fzi.kamp.service.architecturemodel.impl.BackboneModelLoader;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMArchitectureModelProxy;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.AnalysisResult;
import eu.qimpress.resultmodel.MaintainabilityPredictionResult;
import eu.qimpress.resultmodel.ResultModelFactory;
import eu.qimpress.resultmodel.ResultRepository;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class ExportToResultmodelListener
extends SelectionAdapter {
    private static final Logger logger = Logger.getLogger(ExportToResultmodelListener.class);
    private AnalysisManager analysisManager;
    private ResourceSet resourceSet;
    private IMainEditor mainEditor;
    private IQProject qproject;

    public ExportToResultmodelListener(AnalysisManager analysisManager, ResourceSet resourceSet, IMainEditor mainEditor) {
        this.analysisManager = analysisManager;
        this.resourceSet = resourceSet;
        this.mainEditor = mainEditor;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
        super.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Map<ArchitecturalAlternative, List<EffortAnalysisInstance>> architectureToInstancesMap = this.getUsedArchitecturalAlternatives();
        for (ArchitecturalAlternative alternative : architectureToInstancesMap.keySet()) {
            AlternativeEvaluation alternativeEvaluation = this.retrieveAlternativeEvaluation(alternative);
            this.clearOldMaintPredictionResults(alternativeEvaluation);
            MaintainabilityPredictionResult maintPredictionResult = ResultModelFactory.eINSTANCE.createMaintainabilityPredictionResult();
            maintPredictionResult.getEffortanalysisinstances().addAll((Collection)architectureToInstancesMap.get(alternative));
            alternativeEvaluation.getAnalysisResults().add((Object)maintPredictionResult);
        }
        if (this.qproject != null) {
            try {
                new SaveQModelUIOperation(this.qproject.getRepository().getResultModel()).run(null);
            }
            catch (RepositoryException repositoryException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        super.widgetSelected(e);
    }

    private void clearOldMaintPredictionResults(AlternativeEvaluation alternativeEvaluation) {
        ArrayList<AnalysisResult> oldMaintResults = new ArrayList<AnalysisResult>();
        for (AnalysisResult result : alternativeEvaluation.getAnalysisResults()) {
            if (!(result instanceof MaintainabilityPredictionResult)) continue;
            oldMaintResults.add(result);
        }
        if (!oldMaintResults.isEmpty()) {
            alternativeEvaluation.getAnalysisResults().removeAll(oldMaintResults);
        }
    }

    private AlternativeEvaluation retrieveAlternativeEvaluation(ArchitecturalAlternative alternative) {
        if (alternative.getArchitecturemodel() instanceof SAMMArchitectureModelProxy) {
            String name = ((SAMMArchitectureModelProxy)alternative.getArchitecturemodel()).getName();
            IQModel model = BackboneModelLoader.findIQModelForAlternativeName((String)name, (IMainEditor)this.mainEditor);
            List alternativeEvaluations = null;
            String alternativeId = model.getAlternative().getInfo().getId();
            if (this.qproject == null) {
                this.qproject = model.getAlternative().getRepository().getQProject();
            }
            try {
                alternativeEvaluations = model.getAlternative().getRepository().getAlternativeEvaluationsByAlternativeId(alternativeId);
            }
            catch (RepositoryException repositoryException) {
                return null;
            }
            if (!alternativeEvaluations.isEmpty()) {
                return (AlternativeEvaluation)alternativeEvaluations.get(0);
            }
            try {
                AlternativeEvaluation newAlternativeEvaluation = model.getAlternative().getRepository().createAlternativeEvaluation(alternativeId);
                newAlternativeEvaluation.setName(name);
                return newAlternativeEvaluation;
            }
            catch (RepositoryException repositoryException) {}
        }
        return null;
    }

    public void exportToXML(String pathName, ResultRepository resultRoot) {
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)pathName));
        resource.getContents().add((Object)resultRoot);
        Map saveOptions = ((XMLResource)resource).getDefaultSaveOptions();
        saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        saveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        try {
            resource.save(saveOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSAMMUri() {
        FileDialog dialog = new FileDialog(this.mainEditor.getMainEditorShell());
        dialog.setFileName("sample");
        dialog.setFilterExtensions(new String[]{"*.samm_resultmodel"});
        dialog.open();
        String filePath = dialog.getFilterPath();
        String fileName = dialog.getFileName();
        if (filePath.equals("")) {
            return "";
        }
        if (!fileName.contains(".samm_resultmodel")) {
            return String.valueOf(filePath) + "\\" + fileName + ".samm_resultmodel";
        }
        MessageBox box = new MessageBox(this.mainEditor.getMainEditorShell(), 196);
        box.setMessage("The file you wanted to create already exists. Override?");
        int response = box.open();
        if (response == 64) {
            return String.valueOf(filePath) + "\\" + fileName;
        }
        return "";
    }

    private Map<ArchitecturalAlternative, List<EffortAnalysisInstance>> getUsedArchitecturalAlternatives() {
        HashMap<ArchitecturalAlternative, List<EffortAnalysisInstance>> alternativeToInstancesMap = new HashMap<ArchitecturalAlternative, List<EffortAnalysisInstance>>();
        for (EffortAnalysisInstance occuringInstance : this.analysisManager.getAnalysisInstanceManager().getAnalysisInstances()) {
            if (alternativeToInstancesMap.containsKey(occuringInstance.getTargetArchitecturalAlternative())) {
                ((List)alternativeToInstancesMap.get(occuringInstance.getTargetArchitecturalAlternative())).add(occuringInstance);
                continue;
            }
            LinkedList<EffortAnalysisInstance> instanceList = new LinkedList<EffortAnalysisInstance>();
            instanceList.add(occuringInstance);
            alternativeToInstancesMap.put(occuringInstance.getTargetArchitecturalAlternative(), instanceList);
        }
        return alternativeToInstancesMap;
    }
}

