/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.part;

import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class SammVisualIDRegistry {
    private static final String DEBUG_KEY = "eu.qimpress.ide.editors.gmf.composite.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("SAMM Composite".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SammVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SammDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (StaticstructurePackage.eINSTANCE.getCompositeStructure().isSuperTypeOf(domainElement.eClass()) && SammVisualIDRegistry.isDiagram((CompositeStructure)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SammVisualIDRegistry.getModelID(containerView);
        if (!"SAMM Composite".equals(containerModelID)) {
            return -1;
        }
        if ("SAMM Composite".equals(containerModelID)) {
            containerVisualID = SammVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2005: {
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Provided().equals(domainElement.eContainmentFeature())) {
                    return 3015;
                }
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Required().equals(domainElement.eContainmentFeature())) {
                    return 3016;
                }
                if (StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Source().equals(domainElement.eContainmentFeature())) {
                    return 3019;
                }
                if (!StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Sink().equals(domainElement.eContainmentFeature())) break;
                return 3018;
            }
            case 2006: {
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Provided().equals(domainElement.eContainmentFeature())) {
                    return 3015;
                }
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Required().equals(domainElement.eContainmentFeature())) {
                    return 3016;
                }
                if (StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Sink().equals(domainElement.eContainmentFeature())) {
                    return 3018;
                }
                if (!StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Source().equals(domainElement.eContainmentFeature())) break;
                return 3019;
            }
            case 3001: {
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Provided().equals(domainElement.eContainmentFeature())) {
                    return 3011;
                }
                if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Required().equals(domainElement.eContainmentFeature())) {
                    return 3012;
                }
                if (StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Source().equals(domainElement.eContainmentFeature())) {
                    return 3013;
                }
                if (!StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Sink().equals(domainElement.eContainmentFeature())) break;
                return 3014;
            }
            case 7004: {
                if (StaticstructurePackage.eINSTANCE.getSubcomponentInstance().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getCompositeStructure_Subcomponents().equals(domainElement.eContainmentFeature())) {
                    return 3001;
                }
                if (!StaticstructurePackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getCompositeStructure_Connector().equals(domainElement.eContainmentFeature())) break;
                return 3006;
            }
            case 7006: {
                if (!StaticstructurePackage.eINSTANCE.getSubcomponentInstance().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getCompositeStructure_Subcomponents().equals(domainElement.eContainmentFeature())) break;
                return 3020;
            }
            case 7005: {
                if (StaticstructurePackage.eINSTANCE.getSubcomponentInstance().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getCompositeStructure_Subcomponents().equals(domainElement.eContainmentFeature())) {
                    return 3001;
                }
                if (!StaticstructurePackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass()) || !StaticstructurePackage.eINSTANCE.getCompositeStructure_Connector().equals(domainElement.eContainmentFeature())) break;
                return 3006;
            }
            case 1000: {
                if (StaticstructurePackage.eINSTANCE.getCompositeComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (!StaticstructurePackage.eINSTANCE.getServiceArchitectureModel().isSuperTypeOf(domainElement.eClass())) break;
                return 2006;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SammVisualIDRegistry.getModelID(containerView);
        if (!"SAMM Composite".equals(containerModelID)) {
            return false;
        }
        if ("SAMM Composite".equals(containerModelID)) {
            containerVisualID = SammVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2005: {
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3018 == nodeVisualID) {
                    return true;
                }
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5021 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5022 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5023 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5024 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5011 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (5025 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5026 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (5029 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5028 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (StaticstructurePackage.eINSTANCE.getSubcomponentEndpoint().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (StaticstructurePackage.eINSTANCE.getComponentEndpoint().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        return -1;
    }

    private static boolean isDiagram(CompositeStructure element) {
        return true;
    }
}

