/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.commands.DeferredLayoutAllCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramUpdater;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammLinkDescriptor;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammNodeDescriptor;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class CompositeStructureCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = SammDiagramUpdater.getCompositeStructure_1000SemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((SammNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        int visualID = SammVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2005: 
            case 2006: {
                if (semanticChildren.contains(view.getElement())) break;
                return true;
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 0) {
            DeferredLayoutAllCommand layoutCmd = new DeferredLayoutAllCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        HashMap domain2NotationMap = new HashMap();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = SammVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                SammLinkDescriptor nextLinkDescriptor = (SammLinkDescriptor)linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Map domain2NotationMap) {
        if (!"SAMM Composite".equals(SammVisualIDRegistry.getModelID(view))) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        switch (SammVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getCompositeStructure_1000ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getCompositeComponent_2005ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getServiceArchitectureModel_2006ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getSubcomponentInstance_3001ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getInterfacePort_3011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getInterfacePort_3012ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getEventPort_3013ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getEventPort_3014ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getConnector_3006ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getInterfacePort_3015ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getInterfacePort_3016ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getEventPort_3019ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getEventPort_3018ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getSubcomponentEndpoint_4001ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(SammDiagramUpdater.getComponentEndpoint_4002ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Map domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (SammLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), String.valueOf(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map domain2NotationMap) {
        View view = (View)domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

