/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.validation;

import de.uka.ipd.sdq.errorhandling.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.dialogs.issues.IssuesDialog;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.PlatformUI;

public class ShowValidationErrorsJob
implements IJob {
    private final ModelValidationJob[] validationJobs;
    private static final Logger logger = Logger.getLogger(ShowValidationErrorsJob.class);
    private final AbstractWorkflowBasedRunConfiguration configuration;

    public ShowValidationErrorsJob(AbstractWorkflowBasedRunConfiguration configuration, ModelValidationJob ... validationJobs) {
        this.validationJobs = validationJobs;
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ArrayList<SeverityAndIssue> result = new ArrayList<SeverityAndIssue>();
        ModelValidationJob[] modelValidationJobArray = this.validationJobs;
        int n = this.validationJobs.length;
        int n2 = 0;
        while (n2 < n) {
            ModelValidationJob validationJob = modelValidationJobArray[n2];
            result.addAll((Collection<SeverityAndIssue>)validationJob.getResult());
            ++n2;
        }
        if (result.size() > 0) {
            logger.warn((Object)"Found validation problems in the models");
            this.displayValidationErrors(result);
            logger.warn((Object)"Continuing workflow, ignoring model validation issues");
        }
    }

    public String getName() {
        return "Show validation errors";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private void displayValidationErrors(List<SeverityAndIssue> overallResult) throws UserCanceledException {
        ErrorDisplayRunner runner = new ErrorDisplayRunner(overallResult);
        if (this.configuration.isInteractive()) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runner);
            if (!runner.shouldProceedAfterErrorDialog()) {
                throw new UserCanceledException();
            }
        }
    }

    class ErrorDisplayRunner
    implements Runnable {
        private List<SeverityAndIssue> issues;
        private boolean shouldProceed;

        public boolean shouldProceedAfterErrorDialog() {
            return this.shouldProceed;
        }

        public ErrorDisplayRunner(List<SeverityAndIssue> overallResult) {
            this.issues = overallResult;
        }

        @Override
        public void run() {
            IssuesDialog dialog = new IssuesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.issues);
            dialog.open();
            this.shouldProceed = dialog.getReturnCode() == 2;
        }
    }
}

