/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.oaw;

import de.uka.ipd.sdq.workflow.mdsd.oaw.AbstractOAWWorkflowJobBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xpand2.Generator;
import org.eclipse.xpand2.output.JavaBeautifier;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.XmlBeautifier;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfMetaModel;

public class XpandGeneratorJob
extends AbstractOAWWorkflowJobBridge<Generator> {
    private EPackage[] ePackages = null;
    private Outlet[] outlets;
    private String expandExpression;
    private List<String> advices = new ArrayList<String>();
    private boolean checkProtectedRegions;
    private String fileEncoding;
    private boolean beautifyCode;

    public XpandGeneratorJob(HashMap<String, Object> slotContents, EPackage[] ePackages, Outlet[] outlets, String expandExpression) {
        super(new Generator(), slotContents);
        this.ePackages = ePackages;
        this.outlets = outlets;
        this.expandExpression = expandExpression;
        this.checkProtectedRegions = false;
        this.fileEncoding = "ISO-8859-1";
        this.beautifyCode = false;
    }

    @Override
    protected void setupOAWJob(Generator generatorJob) {
        generatorJob.setExpand(this.expandExpression);
        generatorJob.setFileEncoding(this.fileEncoding);
        EPackage[] ePackageArray = this.ePackages;
        int n = this.ePackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage p = ePackageArray[n2];
            generatorJob.addMetaModel((MetaModel)new EmfMetaModel(p));
            ++n2;
        }
        String prResolver = "";
        Outlet[] outletArray = this.outlets;
        int n3 = this.outlets.length;
        n = 0;
        while (n < n3) {
            Outlet o = outletArray[n];
            generatorJob.addOutlet(o);
            prResolver = String.valueOf(prResolver) + o.getPath() + ",";
            ++n;
        }
        prResolver = prResolver.substring(0, prResolver.length() - 1);
        if (this.checkProtectedRegions) {
            generatorJob.setPrSrcPaths(prResolver);
            generatorJob.setPrExcludes(".svn");
        }
        for (String advice : this.advices) {
            generatorJob.addAdvice(advice);
        }
        if (this.beautifyCode) {
            ArrayList<Object> beautifier = new ArrayList<Object>();
            beautifier.add(new JavaBeautifier());
            beautifier.add(new XmlBeautifier());
            generatorJob.setBeautifier(beautifier);
        }
    }

    public List<String> getAdvices() {
        return this.advices;
    }

    public boolean isCheckProtectedRegions() {
        return this.checkProtectedRegions;
    }

    public void setCheckProtectedRegions(boolean checkProtectedRegions) {
        this.checkProtectedRegions = checkProtectedRegions;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getExpandExpression() {
        return this.expandExpression;
    }

    public boolean isBeautifyCode() {
        return this.beautifyCode;
    }

    public void setBeautifyCode(boolean beautifyCode) {
        this.beautifyCode = beautifyCode;
    }
}

