/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.oaw;

import de.uka.ipd.sdq.errorhandling.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.SeverityEnum;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.validation.ModelValidationJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.xtend.check.CheckFacade;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfMetaModel;

public class PerformOAWCheckValidation
extends ModelValidationJob {
    private MDSDBlackboard blackboard;
    private ExecutionContextImpl ctx;
    private String partitionName;
    private String checkFilename;
    private EPackage[] ePackages;

    public PerformOAWCheckValidation(String partitionName, String checkFilename, EPackage[] packages) {
        super(SeverityEnum.ERROR);
        this.partitionName = partitionName;
        this.checkFilename = checkFilename;
        this.ePackages = packages;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IssuesImpl issues = new IssuesImpl();
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.partitionName);
        partition.resolveAllProxies();
        for (Resource r : partition.getResourceSet().getResources()) {
            CheckFacade.checkAll((String)this.checkFilename, this.getElementsInResource(r), (ExecutionContext)this.getExecutionContext(), (Issues)issues);
        }
        this.setJobResult(this.getSeverityAndIssues((Issues)issues));
    }

    public String getName() {
        return "Checking oAW constraints";
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    private Collection<EObject> getElementsInResource(Resource resource) {
        TreeIterator items = resource.getAllContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (items.hasNext()) {
            result.add((EObject)items.next());
        }
        return result;
    }

    private ExecutionContext getExecutionContext() {
        if (this.ctx == null) {
            this.ctx = new ExecutionContextImpl();
            List<EPackage> l = this.getMetamodelPackages();
            for (EPackage pkg : l) {
                this.ctx.registerMetaModel((MetaModel)new EmfMetaModel(pkg));
            }
        }
        return this.ctx;
    }

    private List<SeverityAndIssue> getSeverityAndIssues(Issues issues) {
        MWEDiagnostic issue;
        ArrayList<SeverityAndIssue> result = new ArrayList<SeverityAndIssue>();
        MWEDiagnostic[] mWEDiagnosticArray = issues.getErrors();
        int n = mWEDiagnosticArray.length;
        int n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            if (issue.getElement() instanceof EObject) {
                result.add(new SeverityAndIssue(SeverityEnum.ERROR, issue.getMessage(), (EObject)issue.getElement()));
            } else if (issue.getElement() == null) {
                result.add(new SeverityAndIssue(SeverityEnum.ERROR, issue.getMessage(), null));
            } else {
                result.add(new SeverityAndIssue(SeverityEnum.ERROR, String.valueOf(issue.getMessage()) + issue.getElement().toString(), null));
            }
            ++n2;
        }
        mWEDiagnosticArray = issues.getWarnings();
        n = mWEDiagnosticArray.length;
        n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            result.add(new SeverityAndIssue(SeverityEnum.WARNING, issue.getMessage(), (EObject)issue.getElement()));
            ++n2;
        }
        return result;
    }

    private List<EPackage> getMetamodelPackages() {
        return Arrays.asList(this.ePackages);
    }
}

