/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvtr;

import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTREngine;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.internal.QVTREngines;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class AbstractQVTREngine
implements QVTREngine {
    protected abstract QVTRScriptInfoImpl qvtrScriptInfoImpl();

    protected QVTRScriptInfoImpl createQVTRScriptInfo(HashMap<String, ArrayList<String>> transformationInfo, Boolean valid) {
        return new QVTRScriptInfoImpl(transformationInfo, valid);
    }

    public static AbstractQVTREngine getInstance(String id) {
        QVTREngines[] engines = QVTREngines.getAllEngines();
        int i = 0;
        while (i < engines.length) {
            if (id == null || engines[i].getId() == id) {
                return engines[i].newQVTREngine();
            }
            ++i;
        }
        return null;
    }

    public static AbstractQVTREngine getFirstInstance() {
        return AbstractQVTREngine.getInstance(null);
    }

    public static Collection<String> getAllInstanceIDs() {
        ArrayList<String> engineIDs = new ArrayList<String>();
        QVTREngines[] engines = QVTREngines.getAllEngines();
        int i = 0;
        while (i < engines.length) {
            engineIDs.add(engines[i].getId());
            ++i;
        }
        return engineIDs;
    }

    protected static final class QVTRScriptInfoImpl {
        private HashMap<String, ArrayList<String>> transformationInfo;
        private boolean valid;

        private QVTRScriptInfoImpl() {
        }

        private QVTRScriptInfoImpl(HashMap<String, ArrayList<String>> transformationInfo, Boolean valid) {
            this.transformationInfo = transformationInfo;
            this.valid = valid;
        }

        String[] getDirections(String transformationName) {
            ArrayList<String> directions = this.transformationInfo.get(transformationName);
            if (directions != null) {
                return directions.toArray(new String[0]);
            }
            return null;
        }

        String[] getTransformations() {
            return this.transformationInfo.keySet().toArray(new String[0]);
        }

        Boolean isScriptValid() {
            return this.valid;
        }
    }
}

