/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.blackboard;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class SavePartitionToDiskJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(SavePartitionToDiskJob.class);
    private MDSDBlackboard blackboard;
    private String partitionID;

    public SavePartitionToDiskJob(String partitionID) {
        this.partitionID = partitionID;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        logger.debug((Object)("Saving partition " + this.partitionID));
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.partitionID);
        try {
            partition.storeAllResources();
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to save models", (Throwable)e);
        }
    }

    public String getName() {
        return "Store all resources of a partion to disk";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

