/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.publisher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.publisher.GatheringComputer;

public class FeatureRootAdvice
extends AbstractAdvice {
    private static final int IDX_COMPUTER = 0;
    private static final int IDX_DESCRIPTOR = 1;
    private final Map advice = new HashMap();
    private String featureId;
    private Version featureVersion;

    public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
        if (configSpec == null) {
            return true;
        }
        if (this.advice.containsKey(configSpec)) {
            if (this.featureId != null) {
                if (!this.featureId.equals(id)) {
                    return false;
                }
                return this.featureVersion != null ? this.featureVersion.equals((Object)version) : true;
            }
            return true;
        }
        return false;
    }

    public String[] getConfigs() {
        return this.advice.keySet().toArray(new String[this.advice.size()]);
    }

    public GatheringComputer getRootFileComputer(String config) {
        if (this.advice.containsKey(config)) {
            return (GatheringComputer)((Object[])this.advice.get(config))[0];
        }
        return null;
    }

    public void addRootfiles(String config, GatheringComputer computer) {
        Object[] configAdvice = this.getConfigAdvice(config);
        if (configAdvice[0] == null) {
            configAdvice[0] = computer;
        } else {
            GatheringComputer existing = (GatheringComputer)configAdvice[0];
            existing.addAll(computer);
        }
    }

    public void addPermissions(String config, String permissions, String[] files) {
        FileSetDescriptor descriptor = this.getDescriptor(config);
        int i = 0;
        while (i < files.length) {
            descriptor.addPermissions(new String[]{permissions, files[i]});
            ++i;
        }
    }

    public void addLinks(String config, String links) {
        FileSetDescriptor descriptor = this.getDescriptor(config);
        descriptor.setLinks(links);
    }

    private Object[] getConfigAdvice(String config) {
        Object[] configAdvice = (Object[])this.advice.get(config);
        if (configAdvice == null) {
            configAdvice = new Object[3];
            this.advice.put(config, configAdvice);
        }
        return configAdvice;
    }

    public FileSetDescriptor getDescriptor(String config) {
        Object[] configAdvice = this.getConfigAdvice(config);
        FileSetDescriptor descriptor = null;
        if (configAdvice[1] != null) {
            descriptor = (FileSetDescriptor)configAdvice[1];
        } else {
            String key = "root";
            if (!config.equals(Config.ANY) && config.length() > 0) {
                key = String.valueOf(key) + "." + config;
            }
            descriptor = new FileSetDescriptor(key, config.equals(Config.ANY) ? null : config);
            descriptor.setFiles("");
            configAdvice[1] = descriptor;
        }
        return descriptor;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setFeatureVersion(Version featureVersion) {
        this.featureVersion = featureVersion;
    }
}

