/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class ScopeArea
extends GroupFilterConfigurationArea {
    private Button[] buttons;
    int scope;
    private WorkingSetArea workingSetArea;

    public void applyToGroup(MarkerFieldFilterGroup group) {
        group.setScope(this.scope);
        group.setWorkingSet(this.workingSetArea.getWorkingSet());
    }

    public void createContents(Composite parent) {
        this.buttons = new Button[5];
        this.buttons[0] = this.createRadioButton(parent, MarkerMessages.filtersDialog_anyResource, 0);
        this.buttons[3] = this.createRadioButton(parent, MarkerMessages.filtersDialog_anyResourceInSameProject, 3);
        this.buttons[1] = this.createRadioButton(parent, MarkerMessages.filtersDialog_selectedResource, 1);
        this.buttons[2] = this.createRadioButton(parent, MarkerMessages.filtersDialog_selectedAndChildren, 2);
        this.workingSetArea = new WorkingSetArea(parent);
        this.buttons[4] = this.workingSetArea.getRadioButton();
    }

    protected Button createRadioButton(Composite parent, String text, final int value) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setSelection(value == this.scope);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeArea.this.scope = value;
            }
        });
        return button;
    }

    public String getTitle() {
        return MarkerMessages.filtersDialog_scopeTitle;
    }

    public void initializeFromGroup(MarkerFieldFilterGroup group) {
        this.buttons[this.scope].setSelection(false);
        this.scope = group.getScope();
        this.buttons[this.scope].setSelection(true);
        this.workingSetArea.setWorkingSet(group.getWorkingSet());
    }

    public void apply(MarkerFieldFilter filter) {
    }

    public void initialize(MarkerFieldFilter filter) {
    }

    private class WorkingSetArea {
        Button button;
        Button selectButton;

        WorkingSetArea(Composite parent) {
            this.button = ScopeArea.this.createRadioButton(parent, MarkerMessages.filtersDialog_noWorkingSet, 4);
            GridData data = new GridData(768);
            this.button.setLayoutData((Object)data);
            this.selectButton = new Button(parent, 8);
            this.selectButton.setText(MarkerMessages.filtersDialog_workingSetSelect);
            ScopeArea.this.initializeFontMetrics((Control)parent);
            GridData layoutData = new GridData();
            layoutData.horizontalIndent = 21;
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)ScopeArea.this.getFontMetrics(), (int)61);
            Point minSize = this.selectButton.computeSize(-1, -1, true);
            layoutData.widthHint = Math.max(widthHint, minSize.x);
            this.selectButton.setLayoutData((Object)layoutData);
            this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetArea this$1;
                {
                    this.this$1 = workingSetArea;
                }

                public void widgetSelected(SelectionEvent e) {
                    IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(this.this$1.button.getShell(), false);
                    IWorkingSet workingSet = this.this$1.getWorkingSet();
                    if (workingSet != null) {
                        dialog.setSelection(new IWorkingSet[]{workingSet});
                    }
                    if (dialog.open() == 0) {
                        IWorkingSet[] result = dialog.getSelection();
                        if (result != null && result.length > 0) {
                            this.this$1.setWorkingSet(result[0]);
                        } else {
                            this.this$1.setWorkingSet(null);
                        }
                        if (!this.this$1.getSelection()) {
                            this.this$1.setSelection(true);
                        }
                    }
                }
            });
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean selected) {
            this.button.setSelection(selected);
        }

        void setWorkingSet(IWorkingSet workingSet) {
            this.button.setData((Object)workingSet);
            if (workingSet != null) {
                this.button.setText(NLS.bind((String)MarkerMessages.filtersDialog_workingSet, (Object)workingSet.getLabel()));
            } else {
                this.button.setText(MarkerMessages.filtersDialog_noWorkingSet);
            }
        }

        Button getRadioButton() {
            return this.button;
        }
    }
}

