/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer1;

import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IIntrospectionCallback;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.core.server.layers.layer1.IClientObjectIntrospector;
import org.neodatis.odb.core.server.layers.layer2.meta.ClientNonNativeObjectInfo;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.layers.layer1.introspector.LocalObjectIntrospector;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientObjectIntrospector
extends LocalObjectIntrospector
implements IClientObjectIntrospector {
    protected IOdbList<OID> clientOids = new OdbArrayList<OID>();
    protected Map<OID, ClientNonNativeObjectInfo> aois = new OdbHashMap<OID, ClientNonNativeObjectInfo>();
    protected Map<OID, Object> objects = new OdbHashMap<OID, Object>();
    protected ISession session;
    protected String connectionId;

    public ClientObjectIntrospector(IStorageEngine storageEngine, String connectionId) {
        super(storageEngine);
        this.session = storageEngine.getSession(true);
        this.connectionId = connectionId;
    }

    public ISession getSession() {
        return this.session;
    }

    @Override
    public NonNativeObjectInfo buildNnoi(Object o, ClassInfo info, AbstractObjectInfo[] values, long[] attributesIdentification, int[] attributeIds, Map<Object, NonNativeObjectInfo> alreadyReadObjects) {
        ClientNonNativeObjectInfo cnnoi = new ClientNonNativeObjectInfo(null, info, values, attributesIdentification, attributeIds);
        cnnoi.setLocalOid(OIDFactory.buildObjectOID(alreadyReadObjects.size() + 1));
        OID id = cnnoi.getLocalOid();
        ICache cache = this.getSession().getCache();
        OID oid = cache.getOid(o, false);
        if (oid != null) {
            cnnoi.setOid(oid);
        }
        this.clientOids.add(id);
        this.aois.put(id, cnnoi);
        this.objects.put(id, o);
        return cnnoi;
    }

    @Override
    public IOdbList<OID> getClientOids() {
        return this.clientOids;
    }

    @Override
    public AbstractObjectInfo getMetaRepresentation(Object object, ClassInfo ci, boolean recursive, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        this.clientOids.clear();
        this.aois.clear();
        this.objects.clear();
        return super.getObjectInfo(object, ci, recursive, alreadyReadObjects, callback);
    }

    @Override
    public void synchronizeIds(OID[] clientIds, OID[] serverIds) {
        if (clientIds.length != this.clientOids.size()) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_SERVER_SYNCHRONIZE_IDS.addParameter(this.clientOids.size()).addParameter(clientIds.length));
        }
        ClientNonNativeObjectInfo cnnoi = null;
        ICache cache = this.getSession().getCache();
        Object object = null;
        OID id = null;
        ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.storageEngine.getBaseIdentification().getIdentification());
        for (int i = 0; i < clientIds.length; ++i) {
            id = clientIds[i];
            cnnoi = this.aois.get(id);
            object = this.objects.get(id);
            if (serverIds[i] != null) {
                cnnoi.setOid(serverIds[i]);
                cache.addObject(serverIds[i], object, cnnoi.getHeader());
            }
            if (!OdbConfiguration.reconnectObjectsToSession() || serverIds[i] == null) continue;
            crossSessionCache.addObject(object, serverIds[i]);
        }
    }
}

