/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.engine;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;

public class DefaultByteArrayConverter
implements IByteArrayConverter {
    private String encoding;
    private boolean hasEncoding;
    private static final byte BYTE_FOR_TRUE = 1;
    private static final byte BYTE_FOR_FALSE = 0;
    private static final byte[] BYTES_FOR_TRUE = new byte[]{1};
    private static final byte[] BYTES_FOR_FALSE = new byte[]{0};
    private static int INT_SIZE = 0;
    private static int INT_SIZE_x_2 = 0;

    public void init2() {
        INT_SIZE = ODBType.INTEGER.getSize();
        INT_SIZE_x_2 = INT_SIZE * 2;
        this.setDatabaseCharacterEncoding(OdbConfiguration.getDatabaseCharacterEncoding());
    }

    public byte[] booleanToByteArray(boolean b) {
        if (b) {
            return BYTES_FOR_TRUE;
        }
        return BYTES_FOR_FALSE;
    }

    public void booleanToByteArray(boolean b, byte[] arrayWhereToWrite, int offset) {
        arrayWhereToWrite[offset] = b ? (byte)1 : 0;
    }

    public boolean byteArrayToBoolean(byte[] bytes, int offset) {
        if (bytes[offset] == 0) {
            bytes = null;
            return false;
        }
        bytes = null;
        return true;
    }

    public byte[] shortToByteArray(short s) {
        byte[] b = new byte[2];
        int i = 0;
        int shift = 8;
        while (i < 2) {
            b[i] = (byte)(0xFF & s >> shift);
            ++i;
            shift -= 8;
        }
        return b;
    }

    public short byteArrayToShort(byte[] bytes) {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | bytes[i] & 0xFF);
        }
        bytes = null;
        return result;
    }

    public byte[] charToByteArray(char c) {
        byte[] b = new byte[2];
        int i = 0;
        int shift = 8;
        while (i < 2) {
            b[i] = (byte)(0xFF & c >> shift);
            ++i;
            shift -= 8;
        }
        return b;
    }

    public char byteArrayToChar(byte[] bytes) {
        char result = '\u0000';
        for (int i = 0; i < 2; ++i) {
            result = (char)(result << 8);
            result = (char)(result | bytes[i] & 0xFF);
        }
        bytes = null;
        return result;
    }

    public int getNumberOfBytesOfAString(String s, boolean useEncoding) {
        if (useEncoding && this.hasEncoding) {
            try {
                return s.getBytes(this.encoding).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_ENCODING.addParameter(this.encoding));
            }
        }
        return s.getBytes().length;
    }

    public byte[] stringToByteArray(String s, boolean withSize, int totalSpace, boolean withEncoding) {
        byte[] bytes = null;
        if (withEncoding && this.hasEncoding) {
            try {
                bytes = s.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_ENCODING.addParameter(this.encoding));
            }
        } else {
            bytes = s.getBytes();
        }
        if (!withSize) {
            return bytes;
        }
        int totalSize = 0;
        totalSize = totalSpace == -1 ? OdbConfiguration.getStringSpaceReserveFactor() * bytes.length : totalSpace;
        byte[] bytes2 = new byte[totalSize + INT_SIZE_x_2];
        this.intToByteArray(totalSize, bytes2, 0);
        this.intToByteArray(bytes.length, bytes2, 4);
        System.arraycopy(bytes, 0, bytes2, 8, bytes.length);
        return bytes2;
    }

    public String byteArrayToString(byte[] bytes, boolean hasSize, boolean useEncoding) {
        String s = null;
        if (hasSize) {
            int realSize = this.byteArrayToInt(bytes, INT_SIZE);
            if (useEncoding && this.hasEncoding) {
                try {
                    s = new String(bytes, INT_SIZE_x_2, realSize, this.encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_ENCODING.addParameter(this.encoding));
                }
            } else {
                s = new String(bytes, INT_SIZE_x_2, realSize);
            }
            bytes = null;
            return s;
        }
        if (useEncoding && this.hasEncoding) {
            try {
                s = new String(bytes, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_ENCODING.addParameter(this.encoding));
            }
        } else {
            s = new String(bytes);
        }
        bytes = null;
        return s;
    }

    public byte[] bigDecimalToByteArray(BigDecimal bigDecimal, boolean withSize) {
        return this.stringToByteArray(bigDecimal.toString(), withSize, -1, false);
    }

    public BigDecimal byteArrayToBigDecimal(byte[] bytes, boolean hasSize) {
        String s = this.byteArrayToString(bytes, hasSize, false);
        return new BigDecimal(s);
    }

    public byte[] bigIntegerToByteArray(BigInteger bigInteger, boolean withSize) {
        return this.stringToByteArray(bigInteger.toString(), withSize, -1, false);
    }

    public BigInteger byteArrayToBigInteger(byte[] bytes, boolean hasSize) {
        return new BigInteger(this.byteArrayToString(bytes, hasSize, false));
    }

    public byte[] intToByteArray(int l) {
        byte[] b = new byte[4];
        this.intToByteArray(l, b, 0);
        return b;
    }

    public void intToByteArray(int l, byte[] arrayWhereToWrite, int offset) {
        int i = 0;
        int shift = 24;
        while (i < 4) {
            arrayWhereToWrite[offset + i] = (byte)(0xFF & l >> shift);
            ++i;
            shift -= 8;
        }
    }

    public int byteArrayToInt(byte[] bytes, int offset) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= bytes[i + offset] & 0xFF;
        }
        bytes = null;
        return result;
    }

    public byte[] longToByteArray(long l) {
        byte[] b = new byte[8];
        this.longToByteArray(l, b, 0);
        return b;
    }

    public void longToByteArray(long l, byte[] arrayWhereToWrite, int offset) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            arrayWhereToWrite[offset + i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
    }

    public long byteArrayToLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[i + offset] & 0xFF);
        }
        bytes = null;
        return result;
    }

    public byte[] dateToByteArray(Date date) {
        return this.longToByteArray(date.getTime());
    }

    public Date byteArrayToDate(byte[] bytes) {
        return new Date(this.byteArrayToLong(bytes, 0));
    }

    public byte[] floatToByteArray(float f) {
        int i = Float.floatToIntBits(f);
        return this.intToByteArray(i);
    }

    public float byteArrayToFloat(byte[] bytes) {
        return Float.intBitsToFloat(this.byteArrayToInt(bytes, 0));
    }

    public byte[] doubleToByteArray(double d) {
        long i = Double.doubleToLongBits(d);
        return this.longToByteArray(i);
    }

    public double byteArrayToDouble(byte[] bytes) {
        return Double.longBitsToDouble(this.byteArrayToLong(bytes, 0));
    }

    public void setDatabaseCharacterEncoding(String databaseCharacterEncoding) {
        this.encoding = databaseCharacterEncoding;
        this.hasEncoding = this.encoding != null && !this.encoding.equals("no-encoding");
    }

    public void testEncoding(String encoding) throws UnsupportedEncodingException {
        "test encoding".getBytes(encoding);
    }
}

