/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.update;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.IBrowserContainer;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.gui.objectbrowser.hierarchy.HierarchicObjectBrowserPanel;
import org.neodatis.odb.gui.objectbrowser.hierarchy.ModalObjectBrowserDialog;
import org.neodatis.odb.gui.objectbrowser.update.OIDBuilder;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.impl.tool.ObjectTool;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class NewObjectPanel
extends JPanel
implements ActionListener {
    private IStorageEngine storageEngine;
    private ClassInfo classInfo;
    private JButton btCreate;
    private JButton btCancel;
    private Map<ClassAttributeInfo, JTextField> textFields;
    private Map<JButton, JTextField> idsTextFieldsForButton;
    private Map<JButton, JComboBox> classNames;
    private ILogger logger;
    private IBrowserContainer browser;

    public NewObjectPanel(IStorageEngine aStorageEngine, ClassInfo ci, IBrowserContainer aBrowser, ILogger logger) {
        this.storageEngine = aStorageEngine;
        this.classInfo = ci;
        this.textFields = new OdbHashMap<ClassAttributeInfo, JTextField>();
        this.idsTextFieldsForButton = new OdbHashMap<JButton, JTextField>();
        this.classNames = new OdbHashMap<JButton, JComboBox>();
        this.browser = aBrowser;
        this.logger = logger;
        this.init();
    }

    private void init() {
        JTextField textField = null;
        ClassAttributeInfo cai = null;
        int nbAttributes = this.classInfo.getAttributes().size();
        JPanel panelLabels = new JPanel(new GridLayout(nbAttributes + 1, 1, 5, 5));
        JPanel panelFields = new JPanel(new GridLayout(nbAttributes + 1, 1, 5, 5));
        JPanel panel1 = null;
        JPanel panel2 = null;
        this.setLayout(new BorderLayout(4, 4));
        Color headerFontColor = Color.LIGHT_GRAY;
        Color headerCellColor = new Color(0, 100, 15);
        JLabel label1 = new JLabel(Messages.getString("Attribute Name"));
        label1.setBackground(headerCellColor);
        panel1 = new JPanel();
        panel1.add(label1);
        panelLabels.add(panel1);
        JLabel label3 = new JLabel(Messages.getString("Value"));
        label3.setBackground(headerCellColor);
        panel2 = new JPanel();
        panel2.add(label3);
        panelFields.add(panel2);
        JButton btChoose = null;
        Dimension labelDimension = new Dimension(80, 20);
        JLabel label = null;
        for (int i = 0; i < nbAttributes; ++i) {
            cai = this.classInfo.getAttributeInfo(i);
            if (cai.isNative()) {
                if (cai.getAttributeType().isAtomicNative()) {
                    textField = new JTextField(20);
                    panel1 = new JPanel(new FlowLayout(0));
                    label = new JLabel(cai.getName(), 2);
                    label.setPreferredSize(labelDimension);
                    panel1.add(label);
                    panel1.add(textField);
                    if (cai.getAttributeType().isDate()) {
                        panel1.add(new JLabel("(dd/MM/yyyy HH:mm:ss:SSS)"));
                    }
                    panelLabels.add(panel1);
                } else if (cai.getAttributeType().isArrayOrCollection()) {
                    textField = new JTextField(8);
                    panel1 = new JPanel(new FlowLayout(0));
                    label = new JLabel(cai.getName(), 2);
                    label.setPreferredSize(labelDimension);
                    panel1.add(label);
                    panel1.add(textField);
                    JComboBox combo = this.buildClassesCombo();
                    panel1.add(combo);
                    btChoose = new JButton(Messages.getString("Add an object"));
                    panel1.add(btChoose);
                    btChoose.setActionCommand("browse-add." + cai.getFullClassname());
                    btChoose.addActionListener(this);
                    panelLabels.add(panel1);
                    this.idsTextFieldsForButton.put(btChoose, textField);
                    this.classNames.put(btChoose, combo);
                }
            } else {
                textField = new JTextField(4);
                panel1 = new JPanel(new FlowLayout(0));
                label = new JLabel(cai.getName(), 2);
                label.setPreferredSize(labelDimension);
                panel1.add(label);
                panel1.add(textField);
                btChoose = new JButton(Messages.getString("Choose the object"));
                panel1.add(btChoose);
                btChoose.setActionCommand("browse-set." + cai.getFullClassname());
                btChoose.addActionListener(this);
                panelLabels.add(panel1);
                this.idsTextFieldsForButton.put(btChoose, textField);
            }
            this.textFields.put(cai, textField);
        }
        JPanel optionPanel = new JPanel();
        this.btCreate = new JButton(Messages.getString("Create&commit"));
        this.btCancel = new JButton(Messages.getString("Cancel"));
        optionPanel.add(this.btCancel);
        optionPanel.add(this.btCreate);
        this.btCreate.setActionCommand("create");
        this.btCancel.setActionCommand("cancel");
        this.btCreate.addActionListener(this);
        this.btCancel.addActionListener(this);
        JPanel panelContent = new JPanel(new BorderLayout(5, 5));
        JPanel panel4 = new JPanel();
        panel4.add(panelLabels);
        panelContent.add((Component)panel4, "Center");
        JPanel panel3 = new JPanel(new BorderLayout(5, 5));
        panel3.add((Component)new JScrollPane(panelContent), "Center");
        panel3.add((Component)optionPanel, "South");
        this.add((Component)panel3, "Center");
        this.add((Component)GUITool.buildHeaderPanel(Messages.getString("Create a new object of type ") + this.classInfo.getFullClassName()), "North");
    }

    private JComboBox buildClassesCombo() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.storageEngine.getSession(true).getMetaModel().getAllClasses().iterator();
        ClassInfo ci = null;
        while (iterator.hasNext()) {
            ci = (ClassInfo)iterator.next();
            vector.add(ci.getFullClassName());
        }
        return new JComboBox(vector);
    }

    public void actionPerformed(ActionEvent e) {
        JTextField idTextField;
        OID oid;
        String className;
        String action = e.getActionCommand();
        String tokenSet = "browse-set.";
        String tokenAdd = "browse-add.";
        if (action.startsWith(tokenSet)) {
            className = OdbString.substring(action, tokenSet.length(), action.length());
            try {
                oid = this.chooseObject(className);
                if (oid != StorageEngineConstant.NULL_OBJECT_ID) {
                    idTextField = this.idsTextFieldsForButton.get(e.getSource());
                    idTextField.setText(String.valueOf(oid));
                }
            }
            catch (Exception e1) {
                this.logger.error("Error setting field", e1);
            }
        }
        if (action.startsWith(tokenAdd)) {
            className = this.classNames.get(e.getSource()).getSelectedItem().toString();
            try {
                oid = this.chooseObject(className);
                if (oid != StorageEngineConstant.NULL_OBJECT_ID) {
                    idTextField = this.idsTextFieldsForButton.get(e.getSource());
                    String ids = idTextField.getText();
                    idTextField.setText(ids + (ids.length() > 0 ? "," : "") + String.valueOf(oid));
                }
            }
            catch (Exception e1) {
                this.logger.error("Error setting field", e1);
            }
        }
        if ("create".equals(action)) {
            try {
                this.createObject();
            }
            catch (Exception e1) {
                this.logger.error("Error creating object", e1);
                JOptionPane.showMessageDialog(this, "Error while creating object : " + e1.getMessage());
            }
        }
    }

    private void createObject() throws Exception {
        Iterator<ClassAttributeInfo> iterator = this.textFields.keySet().iterator();
        ClassAttributeInfo cai = null;
        NonNativeObjectInfo nnoi = new NonNativeObjectInfo(this.classInfo);
        while (iterator.hasNext()) {
            cai = iterator.next();
            JTextField tfValue = this.textFields.get(cai);
            String value = tfValue.getText();
            if (cai.isNative()) {
                if (cai.getAttributeType().isAtomicNative()) {
                    nnoi.setAttributeValue(cai.getId(), ObjectTool.stringToObjectInfo(cai.getAttributeType().getId(), value, ObjectTool.ID_CALLER_IS_ODB_EXPLORER, null));
                    continue;
                }
                if (cai.getAttributeType().isCollection()) {
                    ArrayList<AbstractObjectInfo> c = new ArrayList<AbstractObjectInfo>();
                    StringTokenizer tokenizer = new StringTokenizer(value, ",");
                    while (tokenizer.hasMoreElements()) {
                        c.add(new ObjectReference(OIDBuilder.buildObjectOID(tokenizer.nextElement().toString())));
                    }
                    CollectionObjectInfo coi = new CollectionObjectInfo(c);
                    nnoi.setAttributeValue(cai.getId(), coi);
                }
                if (!cai.getAttributeType().isArray()) continue;
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                Object[] objects = new Object[tokenizer.countTokens()];
                int i = 0;
                while (tokenizer.hasMoreElements()) {
                    objects[i++] = new ObjectReference(OIDBuilder.buildObjectOID(tokenizer.nextElement().toString()));
                }
                ArrayObjectInfo aoi = new ArrayObjectInfo(objects);
                nnoi.setAttributeValue(cai.getId(), aoi);
                continue;
            }
            if (value != null && value.length() > 0) {
                nnoi.setAttributeValue(cai.getId(), new ObjectReference(OIDBuilder.buildObjectOID(value)));
                continue;
            }
            nnoi.setAttributeValue(cai.getId(), new NonNativeNullObjectInfo(cai.getClassInfo()));
        }
        DLogger.info("Creating object:" + nnoi);
        OID id = this.storageEngine.writeObjectInfo(StorageEngineConstant.NULL_OBJECT_ID, nnoi, -1L, true);
        this.btCancel.setEnabled(false);
        this.btCreate.setEnabled(false);
        this.btCreate.setText(Messages.getString("Object Created : id = " + id));
    }

    private OID chooseObject(String className) throws Exception {
        Objects l = this.storageEngine.getObjectInfos(new CriteriaQuery(className), true, -1, -1, false);
        ArrayList list = new ArrayList(l.size());
        list.addAll(l);
        ClassInfo classInfoToBrowse = this.storageEngine.getSession(true).getMetaModel().getClassInfo(className, true);
        HierarchicObjectBrowserPanel panel = new HierarchicObjectBrowserPanel(this.browser, this.storageEngine, classInfoToBrowse, list, false, this.logger);
        ModalObjectBrowserDialog modalBrowser = new ModalObjectBrowserDialog(panel);
        modalBrowser.pack();
        modalBrowser.setVisible(true);
        if (modalBrowser.objectHasBeenChoosen()) {
            return panel.getSelectedOid();
        }
        return StorageEngineConstant.NULL_OBJECT_ID;
    }
}

