/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class LoginDialog
extends JDialog
implements ActionListener {
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private boolean isOk;

    public LoginDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title, true);
        this.init();
    }

    private void init() {
        this.isOk = false;
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.tfUserName = new JTextField(10);
        this.tfPassword = new JPasswordField(10);
        JPanel fieldsPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        fieldsPanel.add(new JLabel(this.getLabel("user")));
        fieldsPanel.add(this.tfUserName);
        fieldsPanel.add(new JLabel(this.getLabel("password")));
        fieldsPanel.add(this.tfPassword);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton btLogin = new JButton(this.getLabel("login"));
        btLogin.addActionListener(this);
        buttonPanel.add(btLogin);
        JButton btNoUser = new JButton(this.getLabel("without user"));
        btNoUser.addActionListener(this);
        buttonPanel.add(btNoUser);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add((Component)fieldsPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        this.getContentPane().add(panel);
        this.setBackground(Color.WHITE);
        panel.setBackground(this.getBackground());
        fieldsPanel.setBackground(this.getBackground());
        buttonPanel.setBackground(this.getBackground());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 100;
        this.setLocation(screenSize.width / 2 - inset, screenSize.height / 2 - inset);
    }

    private String getLabel(String string) {
        return string;
    }

    public void actionPerformed(ActionEvent e) {
        this.isOk = true;
        this.dispose();
    }

    public String getUserName() {
        if (!this.isOk || this.tfUserName.getText().length() == 0) {
            return null;
        }
        return this.tfUserName.getText();
    }

    public String getPassword() {
        if (!this.isOk || this.tfPassword.getPassword().length == 0) {
            return null;
        }
        return new String(this.tfPassword.getPassword());
    }

    public static void main(String[] args) {
        LoginDialog dialog = new LoginDialog(null, "login");
        dialog.pack();
        dialog.setVisible(true);
    }
}

