/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;

public class CIZoneInfo
implements Serializable {
    public OID first;
    public OID last;
    protected long nbObjects;
    public ClassInfo ci;

    public CIZoneInfo(ClassInfo ci, OID first, OID last, long nbObjects) {
        this.first = first;
        this.last = last;
        this.nbObjects = nbObjects;
        this.ci = ci;
    }

    public String toString() {
        return "(first=" + this.first + ",last=" + this.last + ",nb=" + this.nbObjects + ")";
    }

    public void reset() {
        this.first = null;
        this.last = null;
        this.nbObjects = 0L;
    }

    public void set(CIZoneInfo zoneInfo) {
        this.nbObjects = zoneInfo.nbObjects;
        this.first = zoneInfo.first;
        this.last = zoneInfo.last;
    }

    public void decreaseNbObjects() {
        --this.nbObjects;
        if (this.nbObjects < 0L) {
            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("nb objects is negative! in " + this.ci.getFullClassName()));
        }
    }

    public void increaseNbObjects() {
        ++this.nbObjects;
    }

    public long getNbObjects() {
        return this.nbObjects;
    }

    public boolean hasObjects() {
        return this.nbObjects != 0L;
    }

    public void setNbObjects(long nb) {
        this.nbObjects = nb;
    }
}

