/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.GroupObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayObjectInfo
extends GroupObjectInfo {
    private String realArrayComponentClassName = ODBType.DEFAULT_ARRAY_COMPONENT_CLASS_NAME;
    private int componentTypeId;

    public ArrayObjectInfo(Object[] array) {
        super((Object)array, 260);
    }

    public ArrayObjectInfo(Object[] array, ODBType type, int componentId) {
        super((Object)array, type);
        this.componentTypeId = componentId;
    }

    public Object[] getArray() {
        return (Object[])this.theObject;
    }

    @Override
    public String toString() {
        if (this.theObject != null) {
            StringBuffer buffer = new StringBuffer();
            Object[] array = this.getArray();
            int length = array.length;
            buffer.append("[").append(length).append("]=(");
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.append(array[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }
        return "null array";
    }

    @Override
    public boolean isArrayObject() {
        return true;
    }

    public String getRealArrayComponentClassName() {
        return this.realArrayComponentClassName;
    }

    public void setRealArrayComponentClassName(String realArrayComponentClassName) {
        this.realArrayComponentClassName = realArrayComponentClassName;
    }

    public int getArrayLength() {
        return this.getArray().length;
    }

    public int getComponentTypeId() {
        return this.componentTypeId;
    }

    public void setComponentTypeId(int componentTypeId) {
        this.componentTypeId = componentTypeId;
    }

    @Override
    public AbstractObjectInfo createCopy(Map<OID, AbstractObjectInfo> cache, boolean onlyData) {
        Object[] array = this.getArray();
        int length = array.length;
        Object[] aois = new AtomicNativeObjectInfo[length];
        for (int i = 0; i < length; ++i) {
            AbstractObjectInfo aoi = (AbstractObjectInfo)array[i];
            aois[i] = aoi.createCopy(cache, onlyData);
        }
        ArrayObjectInfo arrayOfAoi = new ArrayObjectInfo(aois);
        arrayOfAoi.setRealArrayComponentClassName(this.realArrayComponentClassName);
        arrayOfAoi.setComponentTypeId(this.componentTypeId);
        return arrayOfAoi;
    }
}

