/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl.multiplevalue;

import java.util.ArrayList;
import java.util.List;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNodeMultipleValuesPerKey;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.impl.AbstractBTreeNode;
import org.neodatis.btree.tool.BTreeValidator;

public abstract class BTreeNodeMultipleValuesPerKey
extends AbstractBTreeNode
implements IBTreeNodeMultipleValuesPerKey {
    public BTreeNodeMultipleValuesPerKey() {
    }

    public BTreeNodeMultipleValuesPerKey(IBTree btree) {
        super(btree);
    }

    public List getValueAt(int index) {
        return (List)this.values[index];
    }

    public void insertKeyAndValue(Comparable key, Object value) {
        int position = this.getPositionOfKey(key);
        boolean addToExistingCollection = false;
        int realPosition = 0;
        if (position >= 0) {
            addToExistingCollection = true;
            realPosition = position - 1;
        } else {
            realPosition = -position - 1;
        }
        if (realPosition < this.nbKeys && key.compareTo(this.keys[realPosition]) != 0) {
            this.rightShiftFrom(realPosition, true);
        }
        this.keys[realPosition] = key;
        this.manageCollectionValue(realPosition, value);
        if (!addToExistingCollection) {
            ++this.nbKeys;
        }
    }

    private void manageCollectionValue(int realPosition, Object value) {
        ArrayList o = this.values[realPosition];
        if (o == null) {
            this.values[realPosition] = o = new ArrayList();
        } else if (!(o instanceof List)) {
            throw new BTreeException("Value of Non Unique Value BTree should be collection and it is " + o.getClass().getName());
        }
        List l = o;
        l.add(value);
    }

    public List search(Comparable key) {
        int position = this.getPositionOfKey(key);
        boolean keyIsHere = position > 0;
        int realPosition = -1;
        if (keyIsHere) {
            realPosition = position - 1;
            List value = this.getValueAt(realPosition);
            return value;
        }
        if (this.isLeaf()) {
            return null;
        }
        realPosition = -position - 1;
        IBTreeNodeMultipleValuesPerKey node = (IBTreeNodeMultipleValuesPerKey)this.getChildAt(realPosition, true);
        return node.search(key);
    }

    public Object deleteKeyForLeafNode(IKeyAndValue keyAndValue) {
        boolean objectHasBeenFound = false;
        int position = this.getPositionOfKey(keyAndValue.getKey());
        if (position < 0) {
            return null;
        }
        int realPosition = position - 1;
        List value = (List)this.values[realPosition];
        int size = value.size();
        for (int i = 0; i < size && !objectHasBeenFound; ++i) {
            if (!value.get(i).equals(keyAndValue.getValue())) continue;
            value.remove(i);
            objectHasBeenFound = true;
        }
        if (!objectHasBeenFound) {
            return null;
        }
        if (value.size() == 0) {
            this.leftShiftFrom(realPosition, false);
            --this.nbKeys;
        }
        BTreeValidator.validateNode(this);
        return keyAndValue.getValue();
    }
}

