/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.resource.part;

import de.uka.ipd.sdq.pcm.gmf.resource.part.PalladioComponentModelDiagramEditorPlugin;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceEnvironment;
import de.uka.ipd.sdq.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class PalladioComponentModelVisualIDRegistry {
    private static final String DEBUG_KEY = "de.uka.ipd.sdq.pcm.gmf.resource/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("ResourceEnvironmentModel".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return PalladioComponentModelVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                PalladioComponentModelDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment().isSuperTypeOf(domainElement.eClass()) && PalladioComponentModelVisualIDRegistry.isDiagram((ResourceEnvironment)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"ResourceEnvironmentModel".equals(containerModelID)) {
            return -1;
        }
        if ("ResourceEnvironmentModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!ResourceenvironmentPackage.eINSTANCE.getProcessingResourceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7003: {
                if (!ResourceenvironmentPackage.eINSTANCE.getCommunicationLinkResourceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 1000: {
                if (ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (!ResourceenvironmentPackage.eINSTANCE.getLinkingResource().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"ResourceEnvironmentModel".equals(containerModelID)) {
            return false;
        }
        if ("ResourceEnvironmentModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(ResourceEnvironment element) {
        return true;
    }
}

