/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class AvailableUpdateElement
extends AvailableIUElement {
    IInstallableUnit iuToBeUpdated;

    public AvailableUpdateElement(Object parent, IInstallableUnit iu, IInstallableUnit iuToBeUpdated, String profileID, boolean shouldShowChildren) {
        super(parent, iu, profileID, shouldShowChildren);
        this.setIsInstalled(false);
        this.iuToBeUpdated = iuToBeUpdated;
    }

    public IInstallableUnit getIUToBeUpdated() {
        return this.iuToBeUpdated;
    }

    protected ProvisioningPlan getSizingPlan(IProgressMonitor monitor) throws ProvisionException {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.profileID);
        if (this.iuToBeUpdated.getId().equals(this.getIU().getId())) {
            request.removeInstallableUnits(new IInstallableUnit[]{this.iuToBeUpdated});
        }
        request.addInstallableUnits(new IInstallableUnit[]{this.getIU()});
        return ProvisioningUtil.getProvisioningPlan(request, new ProvisioningContext(), monitor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableUpdateElement)) {
            return false;
        }
        if (this.iu == null) {
            return false;
        }
        if (this.iuToBeUpdated == null) {
            return false;
        }
        AvailableUpdateElement other = (AvailableUpdateElement)obj;
        return this.iu.equals((Object)other.getIU()) && this.iuToBeUpdated.equals((Object)other.getIUToBeUpdated());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.iu == null ? 0 : this.iu.hashCode());
        result = 31 * result + (this.iuToBeUpdated == null ? 0 : this.iuToBeUpdated.hashCode());
        return result;
    }
}

