/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.ArtifactRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.query.AnyRequiredCapabilityQuery;
import org.eclipse.equinox.internal.p2.ui.query.AvailableIUWrapper;
import org.eclipse.equinox.internal.p2.ui.query.CategoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.InstalledIUElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.MetadataRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ProfileElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.QueryableProfileRegistry;
import org.eclipse.equinox.internal.p2.ui.query.QueryableUpdates;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.CompoundQuery;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.provisional.p2.ui.model.Updates;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.QueryProvider;
import org.eclipse.osgi.util.NLS;

public class DefaultQueryProvider
extends QueryProvider {
    private Policy policy;
    private Query allQuery = new MatchQuery(){

        public boolean isMatch(Object candidate) {
            return true;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DefaultQueryProvider(Policy policy) {
        this.policy = policy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElementQueryDescriptor getQueryDescriptor(final QueriedElement element) {
        IQueryable queryable = element.getQueryable();
        int queryType = element.getQueryType();
        IUViewQueryContext context = element.getQueryContext();
        if (context == null) {
            context = this.policy.getQueryContext();
        }
        switch (queryType) {
            case 2: {
                queryable = new QueryableArtifactRepositoryManager(context, false);
                return new ElementQueryDescriptor(queryable, new RepositoryLocationQuery(), new Collector(){

                    public boolean accept(Object object) {
                        if (object instanceof URI) {
                            return super.accept((Object)new ArtifactRepositoryElement(element, (URI)object));
                        }
                        return true;
                    }
                });
            }
            case 4: {
                boolean showLatest = context.getShowLatestVersionsOnly();
                boolean hideInstalled = context.getHideAlreadyInstalled();
                IProfile targetProfile = null;
                String profileId = context.getInstalledProfileId();
                if (profileId != null) {
                    try {
                        targetProfile = ProvisioningUtil.getProfile(profileId);
                    }
                    catch (ProvisionException provisionException) {}
                }
                IUPropertyQuery topLevelQuery = new IUPropertyQuery(context.getVisibleAvailableIUProperty(), Boolean.TRUE.toString());
                IUPropertyQuery categoryQuery = new IUPropertyQuery("org.eclipse.equinox.p2.type.category", Boolean.toString(true));
                if (element instanceof MetadataRepositories || element instanceof MetadataRepositoryElement) {
                    if (context.getViewType() != 3) {
                        if (context.getUseCategories()) return new ElementQueryDescriptor(queryable, (Query)categoryQuery, new Collector(), new CategoryElementWrapper(queryable, element));
                    }
                    AvailableIUWrapper wrapper = new AvailableIUWrapper(queryable, element, false, context.getShowAvailableChildren());
                    if (showLatest) {
                        topLevelQuery = new CompositeQuery(new Query[]{topLevelQuery, new LatestIUVersionQuery()});
                    }
                    if (targetProfile == null) return new ElementQueryDescriptor(queryable, (Query)topLevelQuery, new Collector(), wrapper);
                    wrapper.markInstalledIUs(targetProfile, hideInstalled);
                    return new ElementQueryDescriptor(queryable, (Query)topLevelQuery, new Collector(), wrapper);
                }
                if (!(element instanceof CategoryElement)) {
                    if (!(element instanceof IIUElement)) return null;
                    if (!((IIUElement)((Object)element)).shouldShowChildren()) return null;
                }
                boolean drillDown = element instanceof CategoryElement ? context.getShowAvailableChildren() : true;
                AnyRequiredCapabilityQuery meetsAnyRequirementQuery = new AnyRequiredCapabilityQuery(((IIUElement)((Object)element)).getRequirements());
                AvailableIUWrapper availableIUWrapper = new AvailableIUWrapper(queryable, element, true, drillDown);
                if (targetProfile != null) {
                    availableIUWrapper.markInstalledIUs(targetProfile, hideInstalled);
                }
                if (element instanceof CategoryElement) {
                    if (!showLatest) return new ElementQueryDescriptor(queryable, (Query)meetsAnyRequirementQuery, new Collector(), availableIUWrapper);
                    meetsAnyRequirementQuery = new CompositeQuery(new Query[]{meetsAnyRequirementQuery, new LatestIUVersionQuery()});
                    return new ElementQueryDescriptor(queryable, (Query)meetsAnyRequirementQuery, new Collector(), availableIUWrapper);
                }
                CompoundQuery query = CompoundQuery.createCompoundQuery((Query[])new Query[]{topLevelQuery, meetsAnyRequirementQuery}, (boolean)true);
                if (!showLatest) return new ElementQueryDescriptor(queryable, (Query)query, new Collector(), availableIUWrapper);
                query = new CompositeQuery(new Query[]{query, new LatestIUVersionQuery()});
                return new ElementQueryDescriptor(queryable, (Query)query, new Collector(), availableIUWrapper);
            }
            case 5: {
                LatestIUVersionQuery latestIUVersionQuery;
                IProfile profile;
                IInstallableUnit[] toUpdate = null;
                if (element instanceof Updates) {
                    try {
                        profile = ProvisioningUtil.getProfile(((Updates)element).getProfileId());
                    }
                    catch (ProvisionException e) {
                        ProvUI.handleException(e, NLS.bind((String)ProvUIMessages.DefaultQueryProvider_ErrorRetrievingProfile, (Object)((Updates)element).getProfileId()), 1);
                        return null;
                    }
                    toUpdate = ((Updates)element).getIUs();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    profile = (IProfile)ProvUI.getAdapter(element, clazz);
                }
                if (profile == null) {
                    return null;
                }
                if (toUpdate == null) {
                    Collector collector = profile.query((Query)new IUProfilePropertyQuery(profile, context.getVisibleInstalledIUProperty(), Boolean.toString(true)), new Collector(), null);
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz3;
                    }
                    toUpdate = (IInstallableUnit[])collector.toArray((Class)clazz);
                }
                QueryableUpdates updateQueryable = new QueryableUpdates(toUpdate);
                if (context.getShowLatestVersionsOnly()) {
                    latestIUVersionQuery = new LatestIUVersionQuery();
                    return new ElementQueryDescriptor(updateQueryable, (Query)latestIUVersionQuery, new Collector());
                }
                latestIUVersionQuery = this.allQuery;
                return new ElementQueryDescriptor(updateQueryable, (Query)latestIUVersionQuery, new Collector());
            }
            case 6: {
                IProfile profile;
                if (element instanceof IIUElement && context.getShowInstallChildren()) {
                    AnyRequiredCapabilityQuery meetsAnyRequirementQuery = new AnyRequiredCapabilityQuery(((IIUElement)((Object)element)).getRequirements());
                    IUPropertyQuery visibleAsAvailableQuery = new IUPropertyQuery(context.getVisibleAvailableIUProperty(), Boolean.TRUE.toString());
                    return new ElementQueryDescriptor(queryable, (Query)CompoundQuery.createCompoundQuery((Query[])new Query[]{visibleAsAvailableQuery, meetsAnyRequirementQuery}, (boolean)true), new Collector(), new InstalledIUElementWrapper(queryable, element));
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz4;
                }
                if ((profile = (IProfile)ProvUI.getAdapter(element, clazz)) != null) return new ElementQueryDescriptor((IQueryable)profile, (Query)new IUProfilePropertyQuery(profile, context.getVisibleInstalledIUProperty(), Boolean.toString(true)), new Collector(), new InstalledIUElementWrapper((IQueryable)profile, element));
                return null;
            }
            case 1: {
                if (!(element instanceof MetadataRepositories)) return null;
                if (queryable != null) return new ElementQueryDescriptor(element.getQueryable(), new RepositoryLocationQuery(), new Collector(), new MetadataRepositoryElementWrapper(element.getQueryable(), element));
                queryable = new QueryableMetadataRepositoryManager(context, ((MetadataRepositories)element).getIncludeDisabledRepositories());
                element.setQueryable(queryable);
                return new ElementQueryDescriptor(element.getQueryable(), new RepositoryLocationQuery(), new Collector(), new MetadataRepositoryElementWrapper(element.getQueryable(), element));
            }
            case 3: {
                queryable = new QueryableProfileRegistry();
                return new ElementQueryDescriptor(queryable, (Query)new MatchQuery(){

                    public boolean isMatch(Object candidate) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        return ProvUI.getAdapter(candidate, clazz) != null;
                    }
                }, new Collector(), new ProfileElementWrapper(null, (Object)element));
            }
        }
        return null;
    }
}

