/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt6;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.cpp.cdt6.ExtractorLogService;
import de.fzi.sissy.extractors.cpp.cdt6.FileCodeReaderFactory;
import de.fzi.sissy.extractors.cpp.cdt6.MetamodConverter;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.ParsingErrorHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;

public class CDT6Extractor {
    private ModelElementRepository modelElementRepository;
    private MetamodConverter converter;
    private ParserMode mode = ParserMode.COMPLETE_PARSE;
    private ParserLanguage lang = ParserLanguage.CPP;
    private boolean useGNUExtensions = true;
    private ExtractorLogService log = new ExtractorLogService();
    protected static final IParserLogService NULL_LOG = new NullLogService();
    private ExtendedScannerInfo scannerInfo = null;

    public CDT6Extractor(ModelElementRepository modelElementRepository, ExtractorConfiguration extractorConfiguration, Map definitions, List<String> includePaths) {
        this.modelElementRepository = modelElementRepository;
        this.converter = new MetamodConverter(modelElementRepository, extractorConfiguration);
        this.scannerInfo = new ExtendedScannerInfo(definitions, includePaths.toArray(new String[includePaths.size()]));
    }

    public de.fzi.sissy.metamod.File extractFileToMetamod(File f) {
        ParsingErrorHelper.getInstance().setCurrentFile(f.getAbsolutePath());
        this.extractCDT(f);
        de.fzi.sissy.metamod.File file = null;
        file = this.getOrCreateFile(f);
        return file;
    }

    private void extractCDT(File file) {
        try {
            IASTTranslationUnit trUnit = this.parse(file, this.lang, this.useGNUExtensions);
            Debug.info((String)"Done");
            this.converter.convert(trUnit);
            int nProblems = this.converter.getProblems().size();
            if (nProblems == 0) {
                Debug.info((String)"Parsing successful");
            } else {
                Debug.info((String)("Parsing problematic: " + nProblems + " problems found"));
                for (Object o : this.converter.getProblems()) {
                    if (o instanceof IASTProblem) {
                        Debug.error((String)((IASTProblem)o).getMessage());
                        continue;
                    }
                    if (o instanceof ProblemBinding) {
                        Debug.error((String)((ProblemBinding)o).getMessage());
                        continue;
                    }
                    Debug.error((String)"Unknown problem found");
                }
            }
        }
        catch (NullPointerException npe) {
            new Error(npe);
        }
        catch (Exception e) {
            Debug.warning((String)("Exception caught: " + e.getClass().getCanonicalName()));
            e.printStackTrace();
        }
    }

    protected IASTTranslationUnit parse(File file, ParserLanguage lang, boolean useGNUExtensions) {
        Object config;
        CodeReader codeReader = null;
        try {
            codeReader = new CodeReader(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new Error(e);
        }
        IScanner scanner = this.createScanner(codeReader, lang, (IScannerInfo)this.scannerInfo);
        GNUCPPSourceParser parser = null;
        if (lang == ParserLanguage.CPP) {
            config = null;
            config = useGNUExtensions ? new GPPParserExtensionConfiguration() : new ANSICPPParserExtensionConfiguration();
            parser = new GNUCPPSourceParser(scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)this.log, (ICPPParserExtensionConfiguration)config);
        } else {
            config = null;
            config = useGNUExtensions ? new GCCParserExtensionConfiguration() : new ANSICParserExtensionConfiguration();
            parser = new GNUCSourceParser(scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)this.log, (ICParserExtensionConfiguration)config);
        }
        IASTTranslationUnit tu = parser.parse();
        parser.encounteredError();
        return tu;
    }

    public IScanner createScanner(CodeReader codeReader, ParserLanguage lang, IScannerInfo scannerInfo) {
        Object configuration = null;
        configuration = lang == ParserLanguage.C ? GCCScannerExtensionConfiguration.getInstance() : GPPScannerExtensionConfiguration.getInstance();
        CPreprocessor scanner = new CPreprocessor(codeReader, scannerInfo, lang, (IParserLogService)this.log, (IScannerExtensionConfiguration)configuration, (ICodeReaderFactory)FileCodeReaderFactory.getInstance());
        return scanner;
    }

    private de.fzi.sissy.metamod.File getOrCreateFile(File file) {
        de.fzi.sissy.metamod.File existentFile = null;
        for (de.fzi.sissy.metamod.File f : this.modelElementRepository.getRoot().getFiles()) {
            if (!f.getPathName().toLowerCase().equals(file.getAbsolutePath().toLowerCase())) continue;
            existentFile = f;
        }
        if (existentFile == null) {
            existentFile = new de.fzi.sissy.metamod.File(file.getAbsolutePath());
            this.modelElementRepository.getRoot().addFile(existentFile);
        }
        return existentFile;
    }
}

