/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.exc.LoadingException;
import org.apache.bcel.verifier.exc.Utility;

public final class Pass1Verifier
extends PassVerifier {
    private JavaClass jc;
    private Verifier myOwner;

    private JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                this.jc = Repository.lookupClass(this.myOwner.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.jc;
    }

    public Pass1Verifier(Verifier verifier) {
        this.myOwner = verifier;
    }

    public VerificationResult do_verify() {
        JavaClass javaClass;
        try {
            javaClass = this.getJavaClass();
            if (javaClass != null && !this.myOwner.getClassName().equals(javaClass.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + javaClass.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException loadingException) {
            return new VerificationResult(2, loadingException.getMessage());
        }
        catch (ClassFormatException classFormatException) {
            return new VerificationResult(2, classFormatException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + runtimeException.getClass().getName() + " occured:\n" + Utility.getStackTrace(runtimeException));
        }
        if (javaClass != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    public String[] getMessages() {
        return super.getMessages();
    }
}

