/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import org.apache.bcel.verifier.statics.DOUBLE_Upper;
import org.apache.bcel.verifier.statics.LONG_Upper;
import org.apache.bcel.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;

    LocalVariablesInfo(int n) {
        this.localVariableInfos = new LocalVariableInfo[n];
        for (int i = 0; i < n; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int n) {
        if (n < 0 || n >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[n];
    }

    public void add(int n, String string, int n2, int n3, Type type) throws LocalVariableInfoInconsistentException {
        if (n < 0 || n >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[n].add(string, n2, n3, type);
        if (type == Type.LONG) {
            this.localVariableInfos[n + 1].add(string, n2, n3, LONG_Upper.theInstance());
        }
        if (type == Type.DOUBLE) {
            this.localVariableInfos[n + 1].add(string, n2, n3, DOUBLE_Upper.theInstance());
        }
    }
}

