/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class VerifierFactory {
    private static Map hashMap = new HashMap();
    private static List observers = new Vector();

    private VerifierFactory() {
    }

    public static Verifier getVerifier(String string) {
        Verifier verifier = (Verifier)hashMap.get(string);
        if (verifier == null) {
            verifier = new Verifier(string);
            hashMap.put(string, verifier);
            VerifierFactory.notify(string);
        }
        return verifier;
    }

    private static void notify(String string) {
        for (VerifierFactoryObserver verifierFactoryObserver : observers) {
            verifierFactoryObserver.update(string);
        }
    }

    public static Verifier[] getVerifiers() {
        Verifier[] verifierArray = new Verifier[hashMap.values().size()];
        return hashMap.values().toArray(verifierArray);
    }

    public static void attach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.add(verifierFactoryObserver);
    }

    public static void detach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.remove(verifierFactoryObserver);
    }
}

