/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.apache.bcel.generic.ObjectType;

public class EnumElementValueGen
extends ElementValueGen {
    private int typeIdx;
    private int valueIdx;

    protected EnumElementValueGen(int n, int n2, ConstantPoolGen constantPoolGen) {
        super(101, constantPoolGen);
        if (this.type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor");
        }
        this.typeIdx = n;
        this.valueIdx = n2;
    }

    public ElementValue getElementValue() {
        System.err.println("Duplicating value: " + this.getEnumTypeString() + ":" + this.getEnumValueString());
        return new EnumElementValue(this.type, this.typeIdx, this.valueIdx, this.cpGen.getConstantPool());
    }

    public EnumElementValueGen(ObjectType objectType, String string, ConstantPoolGen constantPoolGen) {
        super(101, constantPoolGen);
        this.typeIdx = constantPoolGen.addUtf8(objectType.getSignature());
        this.valueIdx = constantPoolGen.addUtf8(string);
    }

    public EnumElementValueGen(EnumElementValue enumElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(101, constantPoolGen);
        if (bl) {
            this.typeIdx = constantPoolGen.addUtf8(enumElementValue.getEnumTypeString());
            this.valueIdx = constantPoolGen.addUtf8(enumElementValue.getEnumValueString());
        } else {
            this.typeIdx = enumElementValue.getTypeIndex();
            this.valueIdx = enumElementValue.getValueIndex();
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.typeIdx);
        dataOutputStream.writeShort(this.valueIdx);
    }

    public String stringifyValue() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx);
        return constantUtf8.getBytes();
    }

    public String getEnumTypeString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.typeIdx)).getBytes();
    }

    public String getEnumValueString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx)).getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

