/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.apache.bcel.generic.ElementValuePairGen;
import org.apache.bcel.generic.ObjectType;

public class AnnotationEntryGen {
    private int typeIndex;
    private List evs;
    private ConstantPoolGen cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationEntryGen(AnnotationEntry annotationEntry, ConstantPoolGen constantPoolGen, boolean bl) {
        this.cpool = constantPoolGen;
        this.typeIndex = bl ? constantPoolGen.addUtf8(annotationEntry.getAnnotationType()) : annotationEntry.getAnnotationTypeIndex();
        this.isRuntimeVisible = annotationEntry.isRuntimeVisible();
        this.evs = this.copyValues(annotationEntry.getElementValuePairs(), constantPoolGen, bl);
    }

    private List copyValues(ElementValuePair[] elementValuePairArray, ConstantPoolGen constantPoolGen, boolean bl) {
        ArrayList<ElementValuePairGen> arrayList = new ArrayList<ElementValuePairGen>();
        for (ElementValuePair elementValuePair : elementValuePairArray) {
            arrayList.add(new ElementValuePairGen(elementValuePair, constantPoolGen, bl));
        }
        return arrayList;
    }

    private AnnotationEntryGen(ConstantPoolGen constantPoolGen) {
        this.cpool = constantPoolGen;
    }

    public AnnotationEntry getAnnotation() {
        AnnotationEntry annotationEntry = new AnnotationEntry(this.typeIndex, this.cpool.getConstantPool(), this.isRuntimeVisible);
        for (ElementValuePairGen elementValuePairGen : this.evs) {
            annotationEntry.addElementNameValuePair(elementValuePairGen.getElementNameValuePair());
        }
        return annotationEntry;
    }

    public AnnotationEntryGen(ObjectType objectType, List list, boolean bl, ConstantPoolGen constantPoolGen) {
        this.cpool = constantPoolGen;
        this.typeIndex = constantPoolGen.addUtf8(objectType.getSignature());
        this.evs = list;
        this.isRuntimeVisible = bl;
    }

    public static AnnotationEntryGen read(DataInputStream dataInputStream, ConstantPoolGen constantPoolGen, boolean bl) throws IOException {
        AnnotationEntryGen annotationEntryGen = new AnnotationEntryGen(constantPoolGen);
        annotationEntryGen.typeIndex = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedShort();
            annotationEntryGen.addElementNameValuePair(new ElementValuePairGen(n2, ElementValueGen.readElementValue(dataInputStream, constantPoolGen), constantPoolGen));
        }
        annotationEntryGen.isRuntimeVisible(bl);
        return annotationEntryGen;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.typeIndex);
        dataOutputStream.writeShort(this.evs.size());
        for (int i = 0; i < this.evs.size(); ++i) {
            ElementValuePairGen elementValuePairGen = (ElementValuePairGen)this.evs.get(i);
            elementValuePairGen.dump(dataOutputStream);
        }
    }

    public void addElementNameValuePair(ElementValuePairGen elementValuePairGen) {
        if (this.evs == null) {
            this.evs = new ArrayList();
        }
        this.evs.add(elementValuePairGen);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public final String getTypeSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return constantUtf8.getBytes();
    }

    public final String getTypeName() {
        return this.getTypeSignature();
    }

    public List getValues() {
        return this.evs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AnnotationGen:[" + this.getTypeName() + " #" + this.evs.size() + " {");
        for (int i = 0; i < this.evs.size(); ++i) {
            stringBuffer.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@" + this.getTypeName() + "(");
        for (int i = 0; i < this.evs.size(); ++i) {
            stringBuffer.append(this.evs.get(i));
            if (i + 1 >= this.evs.size()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void isRuntimeVisible(boolean bl) {
        this.isRuntimeVisible = bl;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }
}

