/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static ThreadLocal consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    static int[] CHAR_MAP;
    static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    private static int unwrap(ThreadLocal threadLocal) {
        return (Integer)threadLocal.get();
    }

    private static void wrap(ThreadLocal threadLocal, int n) {
        threadLocal.set(new Integer(n));
    }

    public static final String accessToString(int n) {
        return Utility.accessToString(n, false);
    }

    public static final String accessToString(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n2 < 16384) {
            n2 = Utility.pow2(n3);
            if ((n & n2) != 0 && (!bl || n2 != 32 && n2 != 512)) {
                stringBuffer.append(Constants.ACCESS_NAMES[n3]).append(" ");
            }
            ++n3;
        }
        return stringBuffer.toString().trim();
    }

    public static final String classOrInterface(int n) {
        return (n & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 20);
        ByteSequence byteSequence = new ByteSequence(byArray);
        try {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                Utility.codeToString(byteSequence, constantPool, bl);
            }
            n3 = 0;
            while (byteSequence.available() > 0) {
                if (n2 < 0 || n3 < n2) {
                    String string = Utility.fillup(byteSequence.getIndex() + ":", 6, true, ' ');
                    stringBuffer.append(string).append(Utility.codeToString(byteSequence, constantPool, bl)).append('\n');
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.out.println(stringBuffer.toString());
            iOException.printStackTrace();
            throw new ClassFormatException("Byte code error: " + iOException);
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(byte[] byArray, ConstantPool constantPool, int n, int n2) {
        return Utility.codeToString(byArray, constantPool, n, n2, true);
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool, boolean bl) throws IOException {
        int n;
        int n2;
        short s = (short)byteSequence.readUnsignedByte();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(Constants.OPCODE_NAMES[s]);
        if (s == 170 || s == 171) {
            n2 = byteSequence.getIndex() % 4;
            n4 = n2 == 0 ? 0 : 4 - n2;
            for (n = 0; n < n4; ++n) {
                byte by = byteSequence.readByte();
                if (by == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Constants.OPCODE_NAMES[s] + ":" + by);
            }
            n3 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n5 = byteSequence.readInt();
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.getIndex() - 12 - n4 - 1;
                stringBuffer.append("\tdefault = ").append(n3 += n7).append(", low = ").append(n5).append(", high = ").append(n6).append("(");
                int[] nArray = new int[n6 - n5 + 1];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n7 + byteSequence.readInt();
                    stringBuffer.append(nArray[n2]);
                    if (n2 >= nArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 171: {
                int n8 = byteSequence.readInt();
                int n9 = byteSequence.getIndex() - 8 - n4 - 1;
                int[] nArray = new int[n8];
                int[] nArray2 = new int[n8];
                stringBuffer.append("\tdefault = ").append(n3 += n9).append(", npairs = ").append(n8).append(" (");
                for (n2 = 0; n2 < n8; ++n2) {
                    nArray[n2] = byteSequence.readInt();
                    nArray2[n2] = n9 + byteSequence.readInt();
                    stringBuffer.append("(").append(nArray[n2]).append(", ").append(nArray2[n2]).append(")");
                    if (n2 >= n8 - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                stringBuffer.append("\t\t#").append(byteSequence.getIndex() - 1 + byteSequence.readShort());
                break;
            }
            case 200: 
            case 201: {
                stringBuffer.append("\t\t#").append(byteSequence.getIndex() - 1 + byteSequence.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n10;
                if (wide) {
                    n10 = byteSequence.readUnsignedShort();
                    wide = false;
                } else {
                    n10 = byteSequence.readUnsignedByte();
                }
                stringBuffer.append("\t\t%").append(n10);
                break;
            }
            case 196: {
                wide = true;
                stringBuffer.append("\t(wide)");
                break;
            }
            case 188: {
                stringBuffer.append("\t\t<").append(Constants.TYPE_NAMES[byteSequence.readByte()]).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n11 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t").append(constantPool.constantToString(n11, (byte)9)).append(bl ? " (" + n11 + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                stringBuffer.append("\t");
            }
            case 193: {
                int n12 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t<").append(constantPool.constantToString(n12, (byte)7)).append(">").append(bl ? " (" + n12 + ")" : "");
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int n13 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t").append(constantPool.constantToString(n13, (byte)10)).append(bl ? " (" + n13 + ")" : "");
                break;
            }
            case 185: {
                int n14 = byteSequence.readUnsignedShort();
                n2 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t").append(constantPool.constantToString(n14, (byte)11)).append(bl ? " (" + n14 + ")\t" : "").append(n2).append("\t").append(byteSequence.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int n15 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t").append(constantPool.constantToString(n15, constantPool.getConstant(n15).getTag())).append(bl ? " (" + n15 + ")" : "");
                break;
            }
            case 18: {
                int n16 = byteSequence.readUnsignedByte();
                stringBuffer.append("\t\t").append(constantPool.constantToString(n16, constantPool.getConstant(n16).getTag())).append(bl ? " (" + n16 + ")" : "");
                break;
            }
            case 189: {
                int n17 = byteSequence.readUnsignedShort();
                stringBuffer.append("\t\t<").append(Utility.compactClassName(constantPool.getConstantString(n17, (byte)7), false)).append(">").append(bl ? " (" + n17 + ")" : "");
                break;
            }
            case 197: {
                int n18 = byteSequence.readUnsignedShort();
                n = byteSequence.readUnsignedByte();
                stringBuffer.append("\t<").append(Utility.compactClassName(constantPool.getConstantString(n18, (byte)7), false)).append(">\t").append(n).append(bl ? " (" + n18 + ")" : "");
                break;
            }
            case 132: {
                short s2;
                int n19;
                if (wide) {
                    n19 = byteSequence.readUnsignedShort();
                    s2 = byteSequence.readShort();
                    wide = false;
                } else {
                    n19 = byteSequence.readUnsignedByte();
                    s2 = byteSequence.readByte();
                }
                stringBuffer.append("\t\t%").append(n19).append("\t").append(s2);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[s] <= 0) break;
                block27: for (n = 0; n < Constants.TYPE_OF_OPERANDS[s].length; ++n) {
                    stringBuffer.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[s][n]) {
                        case 8: {
                            stringBuffer.append(byteSequence.readByte());
                            continue block27;
                        }
                        case 9: {
                            stringBuffer.append(byteSequence.readShort());
                            continue block27;
                        }
                        case 10: {
                            stringBuffer.append(byteSequence.readInt());
                            continue block27;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String codeToString(ByteSequence byteSequence, ConstantPool constantPool) throws IOException {
        return Utility.codeToString(byteSequence, constantPool, true);
    }

    public static final String compactClassName(String string) {
        return Utility.compactClassName(string, true);
    }

    public static final String compactClassName(String string, String string2, boolean bl) {
        int n = string2.length();
        string = string.replace('/', '.');
        if (bl && string.startsWith(string2) && string.substring(n).indexOf(46) == -1) {
            string = string.substring(n);
        }
        return string;
    }

    public static final String compactClassName(String string, boolean bl) {
        return Utility.compactClassName(string, "java.lang.", bl);
    }

    public static final int setBit(int n, int n2) {
        return n | Utility.pow2(n2);
    }

    public static final int clearBit(int n, int n2) {
        int n3 = Utility.pow2(n2);
        return (n & n3) == 0 ? n : n ^ n3;
    }

    public static final boolean isSet(int n, int n2) {
        return (n & Utility.pow2(n2)) != 0;
    }

    public static final String methodTypeToSignature(String string, String[] stringArray) throws ClassFormatException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = Utility.getSignature(stringArray[i]);
                if (string2.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + stringArray[i]);
                }
                stringBuffer.append(string2);
            }
        }
        string2 = Utility.getSignature(string);
        stringBuffer.append(")").append(string2);
        return stringBuffer.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String string) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(string, true);
    }

    public static final String[] methodSignatureArgumentTypes(String string, boolean bl) throws ClassFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = 1;
            while (string.charAt(n) != ')') {
                arrayList.add(Utility.signatureToString(string.substring(n), bl));
                n += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final String methodSignatureReturnType(String string) throws ClassFormatException {
        return Utility.methodSignatureReturnType(string, true);
    }

    public static final String methodSignatureReturnType(String string, boolean bl) throws ClassFormatException {
        String string2;
        try {
            int n = string.lastIndexOf(41) + 1;
            string2 = Utility.signatureToString(string.substring(n), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        return string2;
    }

    public static final String methodSignatureToString(String string, String string2, String string3) {
        return Utility.methodSignatureToString(string, string2, string3, true);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl) {
        return Utility.methodSignatureToString(string, string2, string3, bl, null);
    }

    public static final String methodSignatureToString(String string, String string2, String string3, boolean bl, LocalVariableTable localVariableTable) throws ClassFormatException {
        String string4;
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = string3.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n2 = 1;
            while (string.charAt(n2) != ')') {
                String string5 = Utility.signatureToString(string.substring(n2), bl);
                stringBuffer.append(string5);
                if (localVariableTable != null) {
                    LocalVariable localVariable = localVariableTable.getLocalVariable(n);
                    if (localVariable != null) {
                        stringBuffer.append(" ").append(localVariable.getName());
                    }
                } else {
                    stringBuffer.append(" arg").append(n);
                }
                n = "double".equals(string5) || "long".equals(string5) ? (n += 2) : ++n;
                stringBuffer.append(", ");
                n2 += Utility.unwrap(consumed_chars);
            }
            string4 = Utility.signatureToString(string.substring(++n2), bl);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        if (stringBuffer.length() > 1) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        return string3 + (string3.length() > 0 ? " " : "") + string4 + " " + string2 + stringBuffer.toString();
    }

    private static final int pow2(int n) {
        return 1 << n;
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = string.indexOf(string2);
            if (n != -1) {
                int n2 = 0;
                while ((n = string.indexOf(string2, n2)) != -1) {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(string3);
                    n2 = n + string2.length();
                }
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println(stringIndexOutOfBoundsException);
        }
        return string;
    }

    public static final String signatureToString(String string) {
        return Utility.signatureToString(string, true);
    }

    public static final String signatureToString(String string, boolean bl) {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int n = string.indexOf(59);
                    if (n < 0) {
                        throw new ClassFormatException("Invalid signature: " + string);
                    }
                    Utility.wrap(consumed_chars, n + 1);
                    return Utility.compactClassName(string.substring(1, n), bl);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (string.charAt(n) == '[') {
                        stringBuffer.append("[]");
                        ++n;
                    }
                    int n2 = n;
                    String string2 = Utility.signatureToString(string.substring(n), bl);
                    int n3 = Utility.unwrap(consumed_chars) + n2;
                    Utility.wrap(consumed_chars, n3);
                    return string2 + stringBuffer.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + string + "'");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid signature: " + stringIndexOutOfBoundsException + ":" + string);
        }
    }

    public static String getSignature(String string) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        block4: for (n2 = 0; n2 < cArray.length; ++n2) {
            switch (cArray[n2]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!bl) continue block4;
                    bl2 = true;
                    continue block4;
                }
                case '[': {
                    if (!bl) {
                        throw new RuntimeException("Illegal type: " + string);
                    }
                    n3 = n2;
                    break block4;
                }
                default: {
                    bl = true;
                    if (bl2) continue block4;
                    stringBuffer.append(cArray[n2]);
                }
            }
        }
        n2 = 0;
        if (n3 > 0) {
            n2 = Utility.countBrackets(string.substring(n3));
        }
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append('[');
        }
        n = 0;
        for (int i = 4; i <= 12 && n == 0; ++i) {
            if (!Constants.TYPE_NAMES[i].equals(string)) continue;
            n = 1;
            stringBuffer.append(Constants.SHORT_TYPE_NAMES[i]);
        }
        if (n == 0) {
            stringBuffer.append('L').append(string.replace('.', '/')).append(';');
        }
        return stringBuffer.toString();
    }

    private static int countBrackets(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '[': {
                    if (bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = true;
                    continue block4;
                }
                case ']': {
                    if (!bl) {
                        throw new RuntimeException("Illegally nested brackets:" + string);
                    }
                    bl = false;
                    ++n;
                    continue block4;
                }
            }
        }
        if (bl) {
            throw new RuntimeException("Illegally nested brackets:" + string);
        }
        return n;
    }

    public static final byte typeOfMethodSignature(String string) throws ClassFormatException {
        try {
            if (string.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            int n = string.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    public static final byte typeOfSignature(String string) throws ClassFormatException {
        try {
            switch (string.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string);
        }
    }

    public static short searchOpcode(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (short s = 0; s < Constants.OPCODE_NAMES.length; s = (short)(s + 1)) {
            if (!Constants.OPCODE_NAMES[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    private static final short byteToShort(byte by) {
        return by < 0 ? (short)(256 + by) : (short)by;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            short s = Utility.byteToShort(byArray[i]);
            String string = Integer.toString(s, 16);
            if (s < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static final String format(int n, int n2, boolean bl, char c) {
        return Utility.fillup(Integer.toString(n), n2, bl, c);
    }

    public static final String fillup(String string, int n, boolean bl, char c) {
        int n2 = n - string.length();
        char[] cArray = new char[n2 < 0 ? 0 : n2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        if (bl) {
            return string + new String(cArray);
        }
        return new String(cArray) + string;
    }

    static final boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final void printArray(PrintStream printStream, Object[] objectArray) {
        printStream.println(Utility.printArray(objectArray, true));
    }

    public static final void printArray(PrintWriter printWriter, Object[] objectArray) {
        printWriter.println(Utility.printArray(objectArray, true));
    }

    public static final String printArray(Object[] objectArray) {
        return Utility.printArray(objectArray, true);
    }

    public static final String printArray(Object[] objectArray, boolean bl) {
        return Utility.printArray(objectArray, bl, false);
    }

    public static final String printArray(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('{');
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuffer.append(bl2 ? "\"" : "").append(objectArray[i].toString()).append(bl2 ? "\"" : "");
            } else {
                stringBuffer.append("null");
            }
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        if (bl) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static String encode(byte[] byArray, boolean bl) throws IOException {
        Closeable closeable;
        Closeable closeable2;
        if (bl) {
            closeable2 = new ByteArrayOutputStream();
            closeable = new GZIPOutputStream((OutputStream)closeable2);
            ((GZIPOutputStream)closeable).write(byArray, 0, byArray.length);
            ((DeflaterOutputStream)closeable).close();
            ((ByteArrayOutputStream)closeable2).close();
            byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        }
        closeable2 = new CharArrayWriter();
        closeable = new JavaWriter((Writer)closeable2);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            ((JavaWriter)closeable).write(n);
        }
        return ((CharArrayWriter)closeable2).toString();
    }

    public static byte[] decode(String string, boolean bl) throws IOException {
        int n;
        char[] cArray = string.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        JavaReader javaReader = new JavaReader(charArrayReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = javaReader.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byteArrayOutputStream.close();
        charArrayReader.close();
        javaReader.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            int n2;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            byte[] byArray2 = new byte[byArray.length * 3];
            int n3 = 0;
            while ((n2 = gZIPInputStream.read()) >= 0) {
                byArray2[n3++] = (byte)n2;
            }
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    public static final String convertString(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Attribute[] getAnnotationAttributes(ConstantPoolGen constantPoolGen, List list) {
        if (list.size() == 0) {
            return null;
        }
        try {
            Object object;
            Object object2;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < list.size(); ++i) {
                object2 = (AnnotationEntryGen)list.get(i);
                if (((AnnotationEntryGen)object2).isRuntimeVisible()) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            DataOutputStream dataOutputStream2 = new DataOutputStream((OutputStream)object2);
            dataOutputStream.writeShort(n);
            dataOutputStream2.writeShort(n2);
            for (int i = 0; i < list.size(); ++i) {
                object = (AnnotationEntryGen)list.get(i);
                if (((AnnotationEntryGen)object).isRuntimeVisible()) {
                    ((AnnotationEntryGen)object).dump(dataOutputStream);
                    continue;
                }
                ((AnnotationEntryGen)object).dump(dataOutputStream2);
            }
            dataOutputStream.close();
            dataOutputStream2.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = ((ByteArrayOutputStream)object2).toByteArray();
            int n3 = -1;
            int n4 = -1;
            if (byArray.length > 2) {
                n3 = constantPoolGen.addUtf8("RuntimeVisibleAnnotations");
            }
            if (((Object)object).length > 2) {
                n4 = constantPoolGen.addUtf8("RuntimeInvisibleAnnotations");
            }
            ArrayList<Annotations> arrayList = new ArrayList<Annotations>();
            if (byArray.length > 2) {
                arrayList.add(new RuntimeVisibleAnnotations(n3, byArray.length, new DataInputStream(new ByteArrayInputStream(byArray)), constantPoolGen.getConstantPool()));
            }
            if (((Object)object).length > 2) {
                arrayList.add(new RuntimeInvisibleAnnotations(n4, ((Object)object).length, new DataInputStream(new ByteArrayInputStream((byte[])object)), constantPoolGen.getConstantPool()));
            }
            return arrayList.toArray(new Attribute[arrayList.size()]);
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing annotations");
            iOException.printStackTrace();
            return null;
        }
    }

    public static Attribute[] getParameterAnnotationAttributes(ConstantPoolGen constantPoolGen, List[] listArray) {
        int[] nArray = new int[listArray.length];
        int n = 0;
        int[] nArray2 = new int[listArray.length];
        int n2 = 0;
        try {
            Object object;
            Object object2;
            Object object3;
            for (int i = 0; i < listArray.length; ++i) {
                object3 = listArray[i];
                if (object3 == null) continue;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object2 = (AnnotationEntryGen)iterator.next();
                    if (((AnnotationEntryGen)object2).isRuntimeVisible()) {
                        int n3 = i;
                        nArray[n3] = nArray[n3] + 1;
                        ++n;
                        continue;
                    }
                    int n4 = i;
                    nArray2[n4] = nArray2[n4] + 1;
                    ++n2;
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object3 = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)object3).writeByte(listArray.length);
            for (int i = 0; i < listArray.length; ++i) {
                ((DataOutputStream)object3).writeShort(nArray[i]);
                if (nArray[i] <= 0) continue;
                object2 = listArray[i];
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (AnnotationEntryGen)iterator.next();
                    if (!((AnnotationEntryGen)object).isRuntimeVisible()) continue;
                    ((AnnotationEntryGen)object).dump((DataOutputStream)object3);
                }
            }
            ((FilterOutputStream)object3).close();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            object2 = new DataOutputStream(byteArrayOutputStream2);
            ((DataOutputStream)object2).writeByte(listArray.length);
            for (int i = 0; i < listArray.length; ++i) {
                ((DataOutputStream)object2).writeShort(nArray2[i]);
                if (nArray2[i] <= 0) continue;
                object = listArray[i];
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    AnnotationEntryGen annotationEntryGen = (AnnotationEntryGen)iterator.next();
                    if (annotationEntryGen.isRuntimeVisible()) continue;
                    annotationEntryGen.dump((DataOutputStream)object2);
                }
            }
            ((FilterOutputStream)object2).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byteArrayOutputStream2.toByteArray();
            int n5 = -1;
            int n6 = -1;
            if (n > 0) {
                n5 = constantPoolGen.addUtf8("RuntimeVisibleParameterAnnotations");
            }
            if (n2 > 0) {
                n6 = constantPoolGen.addUtf8("RuntimeInvisibleParameterAnnotations");
            }
            ArrayList<ParameterAnnotations> arrayList = new ArrayList<ParameterAnnotations>();
            if (n > 0) {
                arrayList.add(new RuntimeVisibleParameterAnnotations(n5, byArray.length, new DataInputStream(new ByteArrayInputStream(byArray)), constantPoolGen.getConstantPool()));
            }
            if (n2 > 0) {
                arrayList.add(new RuntimeInvisibleParameterAnnotations(n6, ((Object)object).length, new DataInputStream(new ByteArrayInputStream((byte[])object)), constantPoolGen.getConstantPool()));
            }
            return arrayList.toArray(new Attribute[arrayList.size()]);
        }
        catch (IOException iOException) {
            System.err.println("IOException whilst processing parameter annotations");
            iOException.printStackTrace();
            return null;
        }
    }

    static {
        int n;
        consumed_chars = new ThreadLocal(){

            protected Object initialValue() {
                return new Integer(0);
            }
        };
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int n2 = 0;
        for (n = 65; n <= 90; ++n) {
            Utility.CHAR_MAP[n2] = n;
            Utility.MAP_CHAR[n] = n2++;
        }
        for (n = 103; n <= 122; ++n) {
            Utility.CHAR_MAP[n2] = n;
            Utility.MAP_CHAR[n] = n2++;
        }
        Utility.CHAR_MAP[n2] = 36;
        Utility.MAP_CHAR[36] = n2++;
        Utility.CHAR_MAP[n2] = 95;
        Utility.MAP_CHAR[95] = n2;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer writer) {
            super(writer);
        }

        public void write(int n) throws IOException {
            if (Utility.isJavaIdentifierPart((char)n) && n != 36) {
                this.out.write(n);
            } else {
                this.out.write(36);
                if (n >= 0 && n < 48) {
                    this.out.write(CHAR_MAP[n]);
                } else {
                    char[] cArray = Integer.toHexString(n).toCharArray();
                    if (cArray.length == 1) {
                        this.out.write(48);
                        this.out.write(cArray[0]);
                    } else {
                        this.out.write(cArray[0]);
                        this.out.write(cArray[1]);
                    }
                }
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.write(cArray[n + i]);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            this.write(string.toCharArray(), n, n2);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n != 36) {
                return n;
            }
            int n2 = this.in.read();
            if (n2 < 0) {
                return -1;
            }
            if (n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102) {
                int n3 = this.in.read();
                if (n3 < 0) {
                    return -1;
                }
                char[] cArray = new char[]{(char)n2, (char)n3};
                int n4 = Integer.parseInt(new String(cArray), 16);
                return n4;
            }
            return MAP_CHAR[n2];
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                cArray[n + i] = (char)this.read();
            }
            return n2;
        }
    }
}

