/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.Visitor;

public abstract class ParameterAnnotations
extends Attribute {
    private int num_parameters;
    private ParameterAnnotationEntry[] parameter_annotation_table;

    ParameterAnnotations(byte by, int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(by, n, n2, (ParameterAnnotationEntry[])null, constantPool);
        this.num_parameters = dataInputStream.readUnsignedByte();
        this.parameter_annotation_table = new ParameterAnnotationEntry[this.num_parameters];
        for (int i = 0; i < this.num_parameters; ++i) {
            this.parameter_annotation_table[i] = new ParameterAnnotationEntry(dataInputStream, constantPool);
        }
    }

    public ParameterAnnotations(byte by, int n, int n2, ParameterAnnotationEntry[] parameterAnnotationEntryArray, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.setParameterAnnotationTable(parameterAnnotationEntryArray);
    }

    public void accept(Visitor visitor) {
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameterAnnotationEntryArray) {
        this.parameter_annotation_table = parameterAnnotationEntryArray;
        this.num_parameters = parameterAnnotationEntryArray == null ? 0 : parameterAnnotationEntryArray.length;
    }

    public final ParameterAnnotationEntry[] getParameterAnnotationTable() {
        return this.parameter_annotation_table;
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        return this.parameter_annotation_table;
    }

    public final int getNumParameterAnnotation() {
        return this.num_parameters;
    }
}

