/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTypeTable
extends Attribute {
    private int local_variable_type_table_length;
    private LocalVariable[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable localVariableTypeTable) {
        this(localVariableTypeTable.getNameIndex(), localVariableTypeTable.getLength(), localVariableTypeTable.getLocalVariableTypeTable(), localVariableTypeTable.getConstantPool());
    }

    public LocalVariableTypeTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)17, n, n2, constantPool);
        this.setLocalVariableTable(localVariableArray);
    }

    LocalVariableTypeTable(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        this.local_variable_type_table_length = dataInputStream.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[this.local_variable_type_table_length];
        for (int i = 0; i < this.local_variable_type_table_length; ++i) {
            this.local_variable_type_table[i] = new LocalVariable(dataInputStream, constantPool);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTypeTable(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.local_variable_type_table_length);
        for (int i = 0; i < this.local_variable_type_table_length; ++i) {
            this.local_variable_type_table[i].dump(dataOutputStream);
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariable getLocalVariable(int n) {
        for (int i = 0; i < this.local_variable_type_table_length; ++i) {
            if (this.local_variable_type_table[i].getIndex() != n) continue;
            return this.local_variable_type_table[i];
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.local_variable_type_table = localVariableArray;
        this.local_variable_type_table_length = localVariableArray == null ? 0 : localVariableArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.local_variable_type_table_length; ++i) {
            stringBuffer.append(this.local_variable_type_table[i].toString());
            if (i >= this.local_variable_type_table_length - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTypeTable localVariableTypeTable = (LocalVariableTypeTable)this.clone();
        localVariableTypeTable.local_variable_type_table = new LocalVariable[this.local_variable_type_table_length];
        for (int i = 0; i < this.local_variable_type_table_length; ++i) {
            localVariableTypeTable.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
        }
        localVariableTypeTable.constant_pool = constantPool;
        return localVariableTypeTable;
    }

    public final int getTableLength() {
        return this.local_variable_type_table_length;
    }
}

