/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Signature;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    protected int name_index;
    protected int signature_index;
    protected int attributes_count;
    protected Attribute[] attributes;
    protected AnnotationEntry[] annotationEntries;
    protected ConstantPool constant_pool;
    private String signatureAttributeString = null;
    private boolean searchedForSignatureAttribute = false;
    private boolean annotationsOutOfDate = true;

    FieldOrMethod() {
    }

    protected FieldOrMethod(FieldOrMethod fieldOrMethod) {
        this(fieldOrMethod.getAccessFlags(), fieldOrMethod.getNameIndex(), fieldOrMethod.getSignatureIndex(), fieldOrMethod.getAttributes(), fieldOrMethod.getConstantPool());
    }

    protected FieldOrMethod(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), null, constantPool);
        this.attributes_count = dataInputStream.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(dataInputStream, constantPool);
        }
    }

    protected FieldOrMethod(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        this.access_flags = n;
        this.name_index = n2;
        this.signature_index = n3;
        this.constant_pool = constantPool;
        this.setAttributes(attributeArray);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        dataOutputStream.writeShort(this.attributes_count);
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i].dump(dataOutputStream);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray == null ? 0 : attributeArray.length;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    public final String getName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    protected FieldOrMethod copy_(ConstantPool constantPool) {
        FieldOrMethod fieldOrMethod = null;
        try {
            fieldOrMethod = (FieldOrMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        fieldOrMethod.constant_pool = this.constant_pool;
        fieldOrMethod.attributes = new Attribute[this.attributes_count];
        for (int i = 0; i < this.attributes_count; ++i) {
            fieldOrMethod.attributes[i] = this.attributes[i].copy(this.constant_pool);
        }
        return fieldOrMethod;
    }

    private void ensureAnnotationsUpToDate() {
        if (this.annotationsOutOfDate) {
            Attribute[] attributeArray = this.getAttributes();
            ArrayList<AnnotationEntry> arrayList = new ArrayList<AnnotationEntry>();
            for (int i = 0; i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                if (!(attribute instanceof Annotations)) continue;
                Annotations annotations = (Annotations)attribute;
                for (int j = 0; j < annotations.getAnnotationEntries().length; ++j) {
                    arrayList.add(annotations.getAnnotationEntries()[j]);
                }
            }
            this.annotationEntries = arrayList.toArray(new AnnotationEntry[arrayList.size()]);
            this.annotationsOutOfDate = false;
        }
    }

    public AnnotationEntry[] getAnnotationEntries() {
        this.ensureAnnotationsUpToDate();
        return this.annotationEntries;
    }

    public void addAnnotationEntry(AnnotationEntry annotationEntry) {
        this.ensureAnnotationsUpToDate();
        int n = this.annotationEntries.length;
        AnnotationEntry[] annotationEntryArray = new AnnotationEntry[n + 1];
        System.arraycopy(this.annotationEntries, 0, annotationEntryArray, 0, n);
        annotationEntryArray[n] = annotationEntry;
        this.annotationEntries = annotationEntryArray;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean bl = false;
            for (int i = 0; !bl && i < this.attributes_count; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                bl = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

