/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;

public class ElementValuePair {
    private ElementValue elementValue;
    private ConstantPool constantPool;
    private int elementNameIndex;

    public ElementValuePair(int n, ElementValue elementValue, ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = n;
        this.constantPool = constantPool;
    }

    public String getNameString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }

    public int getNameIndex() {
        return this.elementNameIndex;
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return stringBuffer.toString();
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.elementNameIndex);
        this.elementValue.dump(dataOutputStream);
    }
}

