/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationElementValue;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.SimpleElementValue;

public abstract class ElementValue {
    protected int type;
    protected ConstantPool cpool;
    public static final int STRING = 115;
    public static final int ENUM_CONSTANT = 101;
    public static final int CLASS = 99;
    public static final int ANNOTATION = 64;
    public static final int ARRAY = 91;
    public static final int PRIMITIVE_INT = 73;
    public static final int PRIMITIVE_BYTE = 66;
    public static final int PRIMITIVE_CHAR = 67;
    public static final int PRIMITIVE_DOUBLE = 68;
    public static final int PRIMITIVE_FLOAT = 70;
    public static final int PRIMITIVE_LONG = 74;
    public static final int PRIMITIVE_SHORT = 83;
    public static final int PRIMITIVE_BOOLEAN = 90;

    public String toString() {
        return this.stringifyValue();
    }

    protected ElementValue(int n, ConstantPool constantPool) {
        this.type = n;
        this.cpool = constantPool;
    }

    public int getElementValueType() {
        return this.type;
    }

    public abstract String stringifyValue();

    public abstract void dump(DataOutputStream var1) throws IOException;

    public static ElementValue readElementValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 66: {
                return new SimpleElementValue(66, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 67: {
                return new SimpleElementValue(67, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 68: {
                return new SimpleElementValue(68, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 70: {
                return new SimpleElementValue(70, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 73: {
                return new SimpleElementValue(73, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 74: {
                return new SimpleElementValue(74, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 83: {
                return new SimpleElementValue(83, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 90: {
                return new SimpleElementValue(90, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 115: {
                return new SimpleElementValue(115, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 101: {
                return new EnumElementValue(101, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), constantPool);
            }
            case 99: {
                return new ClassElementValue(99, dataInputStream.readUnsignedShort(), constantPool);
            }
            case 64: {
                return new AnnotationElementValue(64, AnnotationEntry.read(dataInputStream, constantPool, false), constantPool);
            }
            case 91: {
                int n = dataInputStream.readUnsignedShort();
                ElementValue[] elementValueArray = new ElementValue[n];
                for (int i = 0; i < n; ++i) {
                    elementValueArray[i] = ElementValue.readElementValue(dataInputStream, constantPool);
                }
                return new ArrayElementValue(91, elementValueArray, constantPool);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + by);
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stringifyValue());
        return stringBuffer.toString();
    }
}

