/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.ExportOptionsTab;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class FeatureOptionsTab
extends ExportOptionsTab {
    private static final String S_MULTI_PLATFORM = "multiplatform";
    private static final String S_EXPORT_METADATA = "p2metadata";
    private static final String S_CATEGORY_FILE = "category_file";
    private static final String S_CREATE_CATEGORIES = "create_categories";
    private Button fMultiPlatform;
    private Button fExportMetadata;
    private Button fCategoryButton;
    private Combo fCategoryCombo;
    private Button fCategoryBrowse;

    public FeatureOptionsTab(FeatureExportWizardPage page) {
        super(page);
    }

    protected void addAdditionalOptions(Composite comp) {
        this.fJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.fExportMetadata.setEnabled(FeatureOptionsTab.this.fJarButton.getSelection());
                FeatureOptionsTab.this.fCategoryButton.setEnabled(FeatureOptionsTab.this.fExportMetadata.getSelection() && FeatureOptionsTab.this.fJarButton.getSelection());
                FeatureOptionsTab.this.updateCategoryGeneration();
            }
        });
        this.fExportMetadata = SWTFactory.createCheckButton(comp, PDEUIMessages.ExportWizard_includesMetadata, null, false, 1);
        GridData data = (GridData)this.fExportMetadata.getLayoutData();
        data.horizontalIndent = 20;
        Composite categoryComposite = new Composite(comp, 0);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 20;
        categoryComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        categoryComposite.setLayout((Layout)layout);
        this.fCategoryButton = new Button(categoryComposite, 32);
        this.fCategoryButton.setText(String.valueOf(PDEUIMessages.ExportWizard_generateCategories) + ":");
        this.fCategoryButton.setSelection(true);
        this.fCategoryCombo = new Combo(categoryComposite, 0);
        this.fCategoryCombo.setLayoutData((Object)new GridData(768));
        this.fCategoryBrowse = new Button(categoryComposite, 8);
        this.fCategoryBrowse.setText(PDEUIMessages.ExportWizard_browse);
        this.fCategoryBrowse.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fCategoryBrowse);
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.getDeltaPackFeature();
        if (model != null) {
            this.fMultiPlatform = new Button(comp, 32);
            this.fMultiPlatform.setText(PDEUIMessages.ExportWizard_multi_platform);
        }
    }

    protected String getJarButtonText() {
        return PDEUIMessages.BaseExportWizardPage_fPackageJARs;
    }

    protected boolean doExportMetadata() {
        return this.fExportMetadata.isEnabled() && this.fExportMetadata.getSelection();
    }

    protected URI getCategoryDefinition() {
        File f;
        if (this.doExportCategories() && (f = new File(this.fCategoryCombo.getText().trim())).exists()) {
            return f.toURI();
        }
        return null;
    }

    private boolean doExportCategories() {
        return this.doExportMetadata() && this.fCategoryButton.getSelection() && this.fCategoryCombo.getText().trim().length() > 0;
    }

    protected void initialize(IDialogSettings settings) {
        String selected;
        super.initialize(settings);
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.setSelection(settings.getBoolean(S_MULTI_PLATFORM));
        }
        this.fExportMetadata.setSelection((selected = settings.get(S_EXPORT_METADATA)) == null ? true : Boolean.TRUE.toString().equals(selected));
        this.fExportMetadata.setEnabled(this.fJarButton.getSelection());
        selected = settings.get(S_CREATE_CATEGORIES);
        this.fCategoryButton.setEnabled(this.fExportMetadata.getSelection() && this.fJarButton.getSelection());
        this.fCategoryButton.setSelection(selected == null ? true : Boolean.TRUE.toString().equals(selected));
        if (settings.get(S_CATEGORY_FILE) != null) {
            this.fCategoryCombo.setText(settings.get(S_CATEGORY_FILE));
        }
        this.updateCategoryGeneration();
    }

    protected void saveSettings(IDialogSettings settings) {
        super.saveSettings(settings);
        if (this.fMultiPlatform != null) {
            settings.put(S_MULTI_PLATFORM, this.fMultiPlatform.getSelection());
        }
        settings.put(S_EXPORT_METADATA, this.doExportMetadata());
        settings.put(S_CREATE_CATEGORIES, this.fCategoryButton.getSelection());
        settings.put(S_CATEGORY_FILE, this.fCategoryCombo.getText());
    }

    protected void hookListeners() {
        super.hookListeners();
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeatureOptionsTab.this.fPage.pageChanged();
                }
            });
        }
        this.fExportMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.fCategoryButton.setEnabled(FeatureOptionsTab.this.fExportMetadata.getSelection() && FeatureOptionsTab.this.fJarButton.getSelection());
                FeatureOptionsTab.this.updateCategoryGeneration();
            }
        });
        this.fCategoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.updateCategoryGeneration();
            }
        });
        this.fCategoryBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOptionsTab.this.openFile(FeatureOptionsTab.this.fCategoryCombo);
            }
        });
    }

    protected void updateCategoryGeneration() {
        this.fCategoryBrowse.setEnabled(this.fExportMetadata.getSelection() && this.fCategoryButton.getSelection() && this.fJarButton.getSelection());
        this.fCategoryCombo.setEnabled(this.fExportMetadata.getSelection() && this.fCategoryButton.getSelection() && this.fJarButton.getSelection());
    }

    protected boolean doMultiplePlatform() {
        return this.fMultiPlatform != null && this.fMultiPlatform.getSelection();
    }

    protected void setEnabledForInstall(boolean enabled) {
        super.setEnabledForInstall(enabled);
        this.fExportMetadata.setEnabled(enabled);
        this.fCategoryButton.setEnabled(enabled);
        this.fCategoryCombo.setEnabled(enabled && this.fCategoryButton.getSelection());
        this.fCategoryBrowse.setEnabled(enabled && this.fCategoryButton.getSelection());
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.setEnabled(enabled);
        }
    }

    protected void openFile(Combo combo) {
        String result;
        Object[] objects;
        CategoryResourceListSelectionDialog dialog = new CategoryResourceListSelectionDialog(this.fPage.getShell(), false, (IContainer)PDEPlugin.getWorkspace().getRoot(), 1);
        dialog.setInitialPattern("**");
        dialog.create();
        String path = combo.getText();
        if (path.trim().length() == 0) {
            path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        if (dialog.open() == 0 && (objects = dialog.getResult()).length == 1 && (result = ((IResource)objects[0]).getRawLocation().toOSString()) != null) {
            if (combo.indexOf(result) == -1) {
                combo.add(result, 0);
            }
            combo.setText(result);
        }
    }

    private class CategoryResourceListSelectionDialog
    extends FilteredResourcesSelectionDialog {
        public CategoryResourceListSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
            super(shell, multi, container, typesMask);
            this.addListFilter(new ViewerFilter(this){
                final /* synthetic */ CategoryResourceListSelectionDialog this$1;
                {
                    this.this$1 = categoryResourceListSelectionDialog;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IResource resource = (IResource)element;
                    if (resource != null && resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        String extension = file.getFileExtension();
                        return extension != null && extension.toLowerCase().equals("xml");
                    }
                    return false;
                }
            });
        }

        protected IStatus validateItem(Object item) {
            IResource resource;
            if (item instanceof IResource && (resource = (IResource)item) != null && resource instanceof IFile) {
                try {
                    IContentType type;
                    IFile file = (IFile)resource;
                    IContentDescription description = file.getContentDescription();
                    if (description != null && (type = description.getContentType()) != null && type.getId().equalsIgnoreCase("org.eclipse.pde.categoryManifest")) {
                        return Status.OK_STATUS;
                    }
                }
                catch (CoreException coreException) {}
            }
            return new Status(4, "org.eclipse.pde.ui", PDEUIMessages.FeatureOptionsTab_0);
        }
    }
}

