/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.refactoring.MoveFromChange;
import org.eclipse.pde.internal.ui.refactoring.PDEMoveParticipant;

public class ManifestPackageMoveParticipant
extends PDEMoveParticipant {
    static /* synthetic */ Class class$0;

    protected boolean initialize(Object element) {
        IPackageFragment fragment;
        IJavaProject javaProject;
        IProject project;
        if (element instanceof IPackageFragment && (project = (javaProject = (IJavaProject)(fragment = (IPackageFragment)element).getAncestor(2)).getProject()).exists(ICoreConstants.MANIFEST_PATH)) {
            this.fProject = javaProject.getProject();
            this.fElements = new HashMap();
            this.fElements.put(fragment, this.getNewName(this.getArguments().getDestination(), element));
            return true;
        }
        return false;
    }

    public String getName() {
        return PDEUIMessages.ManifestPackageRenameParticipant_packageRename;
    }

    protected void addChange(CompositeChange result, IProgressMonitor pm) throws CoreException {
        MoveFromChange change;
        IProject destProject;
        IFile file = this.fProject.getFile("META-INF/MANIFEST.MF");
        if (file.exists() && (destProject = this.getDestinationProject()) != null && !this.fProject.equals((Object)destProject) && (change = BundleManifestChange.createMovePackageChange(file, this.fElements.keySet().toArray(), pm)) != null) {
            Change second;
            result.add((Change)change);
            IFile dest = destProject.getFile("META-INF/MANIFEST.MF");
            if (dest.exists() && (second = BundleManifestChange.createMoveToPackageChange(dest, change, pm)) != null) {
                result.add(second);
            }
        }
    }

    private IProject getDestinationProject() {
        Object dest = this.getArguments().getDestination();
        if (dest instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)dest;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                return resource.getProject();
            }
        }
        return null;
    }

    protected boolean isInterestingForExtensions() {
        return false;
    }
}

