/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.ui.launcher.LaunchValidationOperation;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;

public class PluginBlock
extends AbstractPluginBlock {
    protected ILaunchConfiguration fLaunchConfig;
    protected boolean fIsEnabled = false;
    protected boolean fInitDefaultCheckState = false;

    public PluginBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        if (this.fLaunchConfig != null && this.fLaunchConfig.equals(config) && this.fIsEnabled == enableTable) {
            return;
        }
        this.fLaunchConfig = config;
        this.fIsEnabled = enableTable;
        super.initializeFrom(config, enableTable);
        if (enableTable) {
            this.initWorkspacePluginsState(config);
            this.initExternalPluginsState(config);
            this.handleFilterButton();
        }
        this.enableViewer(enableTable);
        this.updateCounter();
        this.fTab.updateLaunchConfigurationDialog();
    }

    public void initialize(boolean enable) throws CoreException {
        if (this.fLaunchConfig != null) {
            this.fInitDefaultCheckState = enable && !this.fLaunchConfig.hasAttribute("selected_workspace_plugins") && !this.fLaunchConfig.hasAttribute("selected_target_plugins");
            this.fTab.updateLaunchConfigurationDialog();
        }
        this.initializeFrom(this.fLaunchConfig, enable);
    }

    protected void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, null, "selected_workspace_plugins");
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.getWorkspaceModels().length);
    }

    protected void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap(configuration, Collections.EMPTY_SET, "selected_target_plugins");
        Iterator iter = map.keySet().iterator();
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            if (!this.fPluginTreeViewer.setChecked((Object)model, true)) continue;
            this.setText(model, map.get(model).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.getExternalModels().length);
    }

    protected boolean isEnabled() {
        return this.fIsEnabled;
    }

    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        if (this.isEnabled() || this.fInitDefaultCheckState) {
            IPluginModelBase[] workspaceModels;
            StringBuffer wBuffer = new StringBuffer();
            StringBuffer tBuffer = new StringBuffer();
            if (this.fInitDefaultCheckState) {
                TreeSet<String> checkedWorkspace = new TreeSet<String>();
                workspaceModels = this.getWorkspaceModels();
                int i = 0;
                while (i < workspaceModels.length) {
                    String id = workspaceModels[i].getPluginBase().getId();
                    if (id != null) {
                        checkedWorkspace.add(id);
                    }
                    ++i;
                }
                IPluginModelBase[] externalModels = this.getExternalModels();
                int i2 = 0;
                while (i2 < externalModels.length) {
                    IPluginModelBase model = externalModels[i2];
                    boolean masked = checkedWorkspace.contains(model.getPluginBase().getId());
                    if (masked) {
                        this.appendToBuffer(wBuffer, model);
                    } else if (model.isEnabled()) {
                        this.appendToBuffer(tBuffer, model);
                    }
                    ++i2;
                }
                this.fInitDefaultCheckState = false;
            } else {
                Object[] selected = this.fPluginTreeViewer.getCheckedElements();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] instanceof IPluginModelBase) {
                        IPluginModelBase model = (IPluginModelBase)selected[i];
                        if (model.getUnderlyingResource() == null) {
                            this.appendToBuffer(tBuffer, model);
                        } else {
                            this.appendToBuffer(wBuffer, model);
                        }
                    }
                    ++i;
                }
            }
            config.setAttribute("selected_workspace_plugins", wBuffer.length() == 0 ? null : wBuffer.toString());
            config.setAttribute("selected_target_plugins", tBuffer.length() == 0 ? null : tBuffer.toString());
            StringBuffer buffer = new StringBuffer();
            if (this.fAddWorkspaceButton.getSelection()) {
                workspaceModels = this.getWorkspaceModels();
                int i = 0;
                while (i < workspaceModels.length) {
                    if (!this.fPluginTreeViewer.getChecked((Object)workspaceModels[i])) {
                        this.appendToBuffer(buffer, workspaceModels[i]);
                    }
                    ++i;
                }
            }
            config.setAttribute("deselected_workspace_plugins", buffer.length() > 0 ? buffer.toString() : null);
        }
    }

    protected void computeSubset() {
        this.validateExtensions();
        super.computeSubset();
    }

    private void validateExtensions() {
        try {
            if (this.fLaunchConfig.getAttribute("useProduct", true)) {
                String product = this.fLaunchConfig.getAttribute("product", null);
                if (product != null) {
                    this.validateLaunchId(product);
                    String application = this.getApplication(product);
                    if (application != null) {
                        this.validateLaunchId(application);
                    }
                }
            } else {
                String configType = this.fLaunchConfig.getType().getIdentifier();
                String attribute = configType.equals("org.eclipse.pde.ui.RuntimeWorkbench") ? "application" : "testApplication";
                String application = this.fLaunchConfig.getAttribute(attribute, TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    this.validateLaunchId(application);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateLaunchId(String launchId) {
        String pluginId;
        IPluginModelBase base;
        int index;
        if (launchId != null && (index = launchId.lastIndexOf(46)) > 0 && (base = this.findPlugin(pluginId = launchId.substring(0, index))) == null && (base = PluginRegistry.findModel((String)pluginId)) != null) {
            this.fPluginTreeViewer.setChecked((Object)base, true);
        }
    }

    private String getApplication(String product) {
        String bundleID = product.substring(0, product.lastIndexOf(46));
        IPluginModelBase model = this.findPlugin(bundleID);
        if (model != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginElement prod;
                IPluginExtension ext = extensions[i];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && product.equals(IdUtil.getFullId((IPluginExtension)ext)) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product")) {
                    IPluginAttribute attr = prod.getAttribute("application");
                    return attr != null ? attr.getValue() : null;
                }
                ++i;
            }
        }
        return null;
    }

    protected LaunchValidationOperation createValidationOperation() {
        return new EclipsePluginValidationOperation(this.fLaunchConfig);
    }
}

