/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeFieldAssistDisposer;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.NewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAttributeDetails;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaJavaAttributeDetails
extends SchemaAttributeDetails {
    private FormEntry fClassEntry;
    private FormEntry fInterfaceEntry;
    private TypeFieldAssistDisposer fClassEntryFieldAssistDisposer;
    private TypeFieldAssistDisposer fInterfaceEntryFieldAssistDisposer;

    public SchemaJavaAttributeDetails(ElementSection section) {
        super(section);
    }

    protected void createTypeDetails(Composite parent, FormToolkit toolkit) {
        this.fClassEntry = new FormEntry(parent, toolkit, PDEUIMessages.SchemaAttributeDetails_extends, PDEUIMessages.SchemaAttributeDetails_browseButton, this.isEditable(), 13);
        this.fInterfaceEntry = new FormEntry(parent, toolkit, PDEUIMessages.SchemaAttributeDetails_implements, PDEUIMessages.SchemaAttributeDetails_browseButton, this.isEditable(), 13);
        this.fClassEntryFieldAssistDisposer = PDEJavaHelperUI.addTypeFieldAssistToText(this.fClassEntry.getText(), this.getPage().getPDEEditor().getCommonProject(), 5);
        this.fInterfaceEntryFieldAssistDisposer = PDEJavaHelperUI.addTypeFieldAssistToText(this.fInterfaceEntry.getText(), this.getPage().getPDEEditor().getCommonProject(), 6);
    }

    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaAttribute)) {
            return;
        }
        super.updateFields(object);
        String basedOn = this.getAttribute().getBasedOn();
        if (basedOn != null && basedOn.length() > 0) {
            int index = basedOn.indexOf(":");
            if (index == -1) {
                String className = basedOn.substring(basedOn.lastIndexOf(".") + 1);
                if (className.length() > 1 && className.charAt(0) == 'I') {
                    this.fClassEntry.setValue("", true);
                    this.fInterfaceEntry.setValue(basedOn, true);
                } else {
                    this.fClassEntry.setValue(basedOn, true);
                    this.fInterfaceEntry.setValue("", true);
                }
            } else {
                this.fClassEntry.setValue(basedOn.substring(0, index), true);
                this.fInterfaceEntry.setValue(basedOn.substring(index + 1), true);
            }
        } else {
            this.fClassEntry.setValue("", true);
            this.fInterfaceEntry.setValue("", true);
        }
        boolean editable = this.isEditableElement();
        this.fClassEntry.setEditable(editable);
        this.fInterfaceEntry.setEditable(editable);
    }

    public void hookListeners() {
        super.hookListeners();
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaJavaAttributeDetails.this.setBasedOn();
            }

            public void linkActivated(HyperlinkEvent e) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String value = SchemaJavaAttributeDetails.this.fClassEntry.getValue();
                if ((value = SchemaJavaAttributeDetails.this.handleLinkActivated(value, false)) != null) {
                    SchemaJavaAttributeDetails.this.fClassEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaJavaAttributeDetails.this.doOpenSelectionDialog(2, SchemaJavaAttributeDetails.this.fClassEntry);
            }
        });
        this.fInterfaceEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaJavaAttributeDetails.this.setBasedOn();
            }

            public void linkActivated(HyperlinkEvent e) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String value = SchemaJavaAttributeDetails.this.fInterfaceEntry.getValue();
                if ((value = SchemaJavaAttributeDetails.this.handleLinkActivated(value, true)) != null) {
                    SchemaJavaAttributeDetails.this.fInterfaceEntry.setValue(value);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                if (SchemaJavaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaJavaAttributeDetails.this.doOpenSelectionDialog(4, SchemaJavaAttributeDetails.this.fInterfaceEntry);
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    NewClassCreationWizard wizard = new NewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    private void setBasedOn() {
        String classEntry = this.fClassEntry.getValue().replaceAll(":", "");
        String interfaceEntry = this.fInterfaceEntry.getValue().replaceAll(":", "");
        StringBuffer sb = new StringBuffer();
        if (classEntry.length() > 0) {
            sb.append(classEntry);
        }
        if (classEntry.length() > 0 || interfaceEntry.length() > 0) {
            sb.append(":");
        }
        if (interfaceEntry.length() > 0) {
            sb.append(interfaceEntry);
        }
        this.getAttribute().setBasedOn(sb.length() > 0 ? sb.toString() : null);
    }

    private void doOpenSelectionDialog(int scopeType, FormEntry entry) {
        try {
            String filter = entry.getValue();
            filter = filter.substring(filter.lastIndexOf(".") + 1);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)scopeType, (boolean)false, (String)filter);
            dialog.setTitle(PDEUIMessages.GeneralInfoSection_selectionTitle);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                entry.setValue(type.getFullyQualifiedName('$'));
                entry.commit();
            }
        }
        catch (CoreException coreException) {}
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fClassEntry.commit();
        this.fInterfaceEntry.commit();
    }

    public void dispose() {
        super.dispose();
        if (this.fClassEntryFieldAssistDisposer != null) {
            this.fClassEntryFieldAssistDisposer.dispose();
        }
        if (this.fInterfaceEntryFieldAssistDisposer != null) {
            this.fInterfaceEntryFieldAssistDisposer.dispose();
        }
    }
}

