/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionHyperLink;
import org.eclipse.pde.internal.ui.editor.text.BundleHyperlink;
import org.eclipse.pde.internal.ui.editor.text.JavaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.PackageHyperlink;
import org.eclipse.pde.internal.ui.editor.text.ResourceHyperlink;
import org.eclipse.pde.internal.ui.editor.text.SchemaHyperlink;
import org.eclipse.pde.internal.ui.editor.text.TranslationHyperlink;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;

public class HyperlinkAction
extends Action
implements MouseListener,
KeyListener {
    protected IHyperlinkDetector fDetector;
    protected StyledText fStyledText;
    protected IHyperlink fLink;
    static /* synthetic */ Class class$0;

    public HyperlinkAction() {
        this.setImageDescriptor(PDEPluginImages.DESC_LINK_OBJ);
        this.setEnabled(false);
    }

    public void run() {
        if (this.fLink != null) {
            this.fLink.open();
        }
    }

    public IHyperlink getHyperLink() {
        return this.fLink;
    }

    protected void removeListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.removeMouseListener((MouseListener)this);
        this.fStyledText.removeKeyListener((KeyListener)this);
    }

    protected void addListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.addMouseListener((MouseListener)this);
        this.fStyledText.addKeyListener((KeyListener)this);
    }

    public boolean detectHyperlink() {
        this.fLink = null;
        if (!this.hasDetector() || this.isTextDisposed()) {
            return false;
        }
        Point p = this.fStyledText.getSelection();
        IHyperlink[] links = this.fDetector.detectHyperlinks(null, (IRegion)new Region(p.x, p.y - p.x), false);
        if (links == null || links.length == 0) {
            return false;
        }
        this.fLink = links[0];
        return true;
    }

    public void setTextEditor(ITextEditor editor) {
        IHyperlinkDetector iHyperlinkDetector;
        StyledText newText;
        StyledText styledText = newText = editor instanceof PDESourcePage ? ((PDESourcePage)editor).getViewer().getTextWidget() : null;
        if (this.fStyledText != null && this.fStyledText.equals(newText)) {
            return;
        }
        this.removeListeners();
        this.fStyledText = newText;
        if (editor instanceof PDESourcePage) {
            PDESourcePage pDESourcePage = (PDESourcePage)editor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.hyperlink.IHyperlinkDetector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iHyperlinkDetector = (IHyperlinkDetector)pDESourcePage.getAdapter(clazz);
        } else {
            iHyperlinkDetector = null;
        }
        this.fDetector = iHyperlinkDetector;
        this.addListeners();
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    protected boolean hasDetector() {
        return this.fDetector != null;
    }

    private boolean isTextDisposed() {
        return this.fStyledText == null || this.fStyledText.isDisposed();
    }

    public void generateActionText() {
        String text = PDEUIMessages.HyperlinkActionNoLinksAvailable;
        if (this.fLink instanceof JavaHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenType;
        } else if (this.fLink instanceof ExtensionHyperLink) {
            text = PDEUIMessages.HyperlinkActionOpenDescription;
        } else if (this.fLink instanceof BundleHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenBundle;
        } else if (this.fLink instanceof PackageHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenPackage;
        } else if (this.fLink instanceof ResourceHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenResource;
        } else if (this.fLink instanceof SchemaHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenSchema;
        } else if (this.fLink instanceof TranslationHyperlink) {
            text = PDEUIMessages.HyperlinkActionOpenTranslation;
        }
        this.setText(text);
        this.setToolTipText(text);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void keyPressed(KeyEvent e) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void keyReleased(KeyEvent e) {
    }
}

