/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.views;

import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.IVisualisation;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.AbstractReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.IReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reports.RReport;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RConnection;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.views.HTMLVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractHtmlReportView
extends AbstractReportView
implements IVisualisation<SensorAndMeasurements> {
    private Browser browser;

    public abstract RReport getReport();

    protected void createReportControls(Composite parent) {
        this.browser = new Browser(parent, 2048);
        this.setInput(Collections.EMPTY_LIST);
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void addInput(Collection<SensorAndMeasurements> c) {
    }

    @Override
    public void deleteInput(Collection<SensorAndMeasurements> c) {
    }

    @Override
    public void setInput(Collection<SensorAndMeasurements> c) {
        if (RConnection.isEngineAvailable()) {
            if (c.isEmpty()) {
                this.browser.setText("<html><body><h1>Error! </h1>At least the measurements for one sensor must be available!</body></html>");
            } else if (this.getReport() == null) {
                this.browser.setText("<html><body><h1>Error!</h1> There is no report associated with this view. Ask the developer to correct this error. </body></html>");
            } else {
                RConnection rConnection = RConnection.getRConnection();
                ArrayList<IReportItem> items = this.getReport().prepareReportItems(c, rConnection);
                HTMLVisitor visitor = new HTMLVisitor();
                for (IReportItem item : items) {
                    item.generateData(rConnection);
                    item.visit(visitor);
                }
                this.browser.setText(visitor.getHTML());
            }
        } else {
            this.browser.setText("<html><body><h1>Error! </h1>Connection to R engine is not available!</body></html>");
        }
    }

    protected void generateVisualization(List<DataAdapter> list) {
        ArrayList<SensorAndMeasurements> viewerInput = new ArrayList<SensorAndMeasurements>();
        for (DataAdapter a : list) {
            viewerInput.add((SensorAndMeasurements)a.getAdaptedObject());
        }
        this.setInput((Collection<SensorAndMeasurements>)viewerInput);
    }
}

