/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reports;

import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.DensityPlotReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.IReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.RCommandRReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.StaticTextReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reports.RReport;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RConnection;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.REngineHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DistributionComparisonReport
extends RReport {
    @Override
    public ArrayList<IReportItem> prepareReportItems(Collection<SensorAndMeasurements> c, RConnection t) {
        ArrayList<IReportItem> items = new ArrayList<IReportItem>();
        items.add(new StaticTextReportItem("R-Report for comparing distributions.", true));
        if (c.size() != 2) {
            items.add(new StaticTextReportItem("You need to add two sensors to this report. You added " + c.size() + (c.size() == 1 ? " sensor." : " sensors.") + " Use the property sheet to add or delete sensors.", false));
            return items;
        }
        ArrayList<String> data = new ArrayList<String>();
        Iterator<SensorAndMeasurements> it = c.iterator();
        SensorAndMeasurements[] sm = new SensorAndMeasurements[2];
        int i = 0;
        while (i < 2) {
            sm[i] = it.next();
            String sensorName = REngineHelper.storeMeasurementsInRVector(sm[i], i, RReport.TimeseriesData.TIMESPAN, t);
            data.add("density(" + sensorName + ")");
            DensityPlotReportItem densityPlot = new DensityPlotReportItem("Distribution/Density Plot", "Time");
            densityPlot.addData(sm[i].getSensor().getSensorName(), "Response Time", "density(" + sensorName + ")");
            items.add(densityPlot);
            String rCommand = "length(" + sensorName + ")\n";
            items.add(new RCommandRReportItem(rCommand, "Number of observations of Sensor " + sm[i].getSensor().getSensorName()));
            rCommand = "mean(" + sensorName + ")\n";
            items.add(new RCommandRReportItem(rCommand, "Mean of Sensor " + sm[i].getSensor().getSensorName()));
            rCommand = "sd(" + sensorName + ")\n";
            items.add(new RCommandRReportItem(rCommand, "Standard-Deviation of Sensor " + sm[i].getSensor().getSensorName()));
            ++i;
        }
        int pos = 1;
        items.add(pos++, new StaticTextReportItem("Comparing sensors " + sm[0].getSensor().getSensorName() + " and " + sm[1].getSensor().getSensorName(), false));
        items.add(pos++, new StaticTextReportItem("KS test.", true));
        items.add(pos++, new RCommandRReportItem("ks.test(sensor0,sensor1)$method", "The applied test for the sensors"));
        items.add(pos++, new RCommandRReportItem("ks.test(sensor0,sensor1)$statistic", "The value of the test statistics"));
        items.add(pos++, new RCommandRReportItem("ks.test(sensor0,sensor1)$p.value", "The p-value of the test"));
        items.add(pos++, new StaticTextReportItem("Chi^2 test.", true));
        int max = sm[0].getMeasurements().size() < sm[1].getMeasurements().size() ? sm[0].getMeasurements().size() : sm[1].getMeasurements().size();
        max = max > 2500 ? 2500 : max;
        items.add(pos++, new RCommandRReportItem("chisq.test(sensor0[1:" + max + "],sensor1[1:" + max + "])$method", "The applied test for the sensors"));
        items.add(pos++, new RCommandRReportItem("chisq.test(sensor0[1:" + max + "],sensor1[1:" + max + "])$statistic", "The value of the test statistics"));
        items.add(pos++, new RCommandRReportItem("chisq.test(sensor0[1:" + max + "],sensor1[1:" + max + "])$p.value", "The p-value of the test"));
        return items;
    }
}

