/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems;

import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.AbstractPlotReportItem;

public class HistogramReportItem
extends AbstractPlotReportItem {
    public static final String DEFAULT_X_AXIS_LABEL = "";
    public static final int DEFAULT_NUMBER_CLASSES = 10;
    private String xAxisLabel = "";
    private int columns = 10;

    public HistogramReportItem(String title, String xAxisLabel) {
        super(title);
        this.xAxisLabel = xAxisLabel;
    }

    public HistogramReportItem(String title, int height, int width, int fontSize, String xAxisLabel) {
        super(title, height, width, fontSize);
        this.xAxisLabel = DEFAULT_X_AXIS_LABEL;
    }

    @Override
    protected String generatePlotCommand() {
        String rCommand = "require(plotrix)\n";
        String list = "l = list(";
        int pos = 0;
        String[] stringArray = this.getDataSeries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String data = this.getDataCommand(id);
            String sep = pos == 0 ? DEFAULT_X_AXIS_LABEL : ", ";
            list = String.valueOf(list) + sep + data;
            ++pos;
            ++n2;
        }
        list = String.valueOf(list) + ")\n";
        rCommand = String.valueOf(rCommand) + list;
        rCommand = String.valueOf(rCommand) + "multhist(l, breaks=" + this.columns + ", freq=FALSE, " + "main=\"" + this.getDescription() + "\", " + "title=\"Histogram\", " + "xlab=\"" + this.xAxisLabel + "\", " + "ylab=\"Density\")\n";
        rCommand = String.valueOf(rCommand) + this.generateColorsLegend();
        return rCommand;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }
}

