/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems;

import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.AbstractPlotReportItem;

public class CdfReportItem
extends AbstractPlotReportItem {
    public static final String DEFAULT_X_AXIS_LABEL = "";
    private String xAxisLabel = "";

    public CdfReportItem(String title, String xAxisLabel) {
        super(title);
        this.xAxisLabel = xAxisLabel;
    }

    public CdfReportItem(String title, int height, int width, int fontSize, String xAxisLabel) {
        super(title, height, width, fontSize);
        this.xAxisLabel = DEFAULT_X_AXIS_LABEL;
    }

    @Override
    protected String generatePlotCommand() {
        int pos = 0;
        String sort = DEFAULT_X_AXIS_LABEL;
        String range = "r = range(";
        String plot = DEFAULT_X_AXIS_LABEL;
        String[] stringArray = this.getDataSeries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String data = this.getDataCommand(id);
            String sdata = "s_" + data;
            String sep = pos == 0 ? DEFAULT_X_AXIS_LABEL : ", ";
            range = String.valueOf(range) + sep + data;
            sort = String.valueOf(sort) + sdata + " = sort(" + data + ")\n";
            plot = pos == 0 ? String.valueOf(plot) + "plot(ecdf(" + sdata + "), xlim=r, " + "do.points=FALSE, " + "verticals=TRUE, " + "main=\"" + this.getDescription() + "\", " + "xlab=\"" + this.xAxisLabel + "\", " + "ylab=\"F(t)\")\n" : String.valueOf(plot) + "lines(" + sdata + ", (1:length(" + sdata + "))/length(" + sdata + " ),type=\"s\", lty=" + (pos + 1) + ")\n";
            ++pos;
            ++n2;
        }
        range = String.valueOf(range) + ")\n";
        String rCommand = String.valueOf(sort) + range + plot;
        rCommand = String.valueOf(rCommand) + this.generateLinesLegend();
        return rCommand;
    }
}

